/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.web.service.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.portal.json.web.service.client.JSONWebServiceClient;
import com.liferay.portal.json.web.service.client.JSONWebServiceInvocationException;
import com.liferay.portal.json.web.service.client.JSONWebServiceSerializeException;
import com.liferay.portal.json.web.service.client.JSONWebServiceTransportException;
import com.liferay.portal.json.web.service.client.internal.AsyncHttpClient;
import com.liferay.portal.json.web.service.client.internal.IdleConnectionMonitorThread;
import com.liferay.portal.json.web.service.client.internal.X509TrustManagerImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public abstract class BaseJSONWebServiceClientImpl
implements JSONWebServiceClient {
    private static final Charset _CHARSET = Charset.forName("UTF-8");
    private static final Log _log = LogFactoryUtil.getLog(BaseJSONWebServiceClientImpl.class);
    private static final Pattern _errorMessagePattern = Pattern.compile("errorCode\":\\s*(\\d+).+message\":.+status\":\\s*(\\d+)");
    private static final Pattern _statusPattern = Pattern.compile("status\":(\\d+)");
    private AsyncHttpClient _asyncHttpClient;
    private ClassLoader _classLoader;
    private String _contextPath;
    private Map<String, String> _headers = Collections.emptyMap();
    private String _hostName;
    private int _hostPort = 80;
    private IdleConnectionMonitorThread _idleConnectionMonitorThread;
    private KeyStore _keyStore;
    private String _login;
    private int _maxAttempts;
    private String _oAuthAccessSecret;
    private String _oAuthAccessToken;
    private String _oAuthConsumerKey;
    private String _oAuthConsumerSecret;
    private final ObjectMapper _objectMapper = new ObjectMapper();
    private String _password;
    private String _protocol = "http";
    private String _proxyAuthType;
    private String _proxyDomain;
    private String _proxyHostName;
    private int _proxyHostPort;
    private String _proxyLogin;
    private String _proxyPassword;
    private String _proxyWorkstation;
    private boolean _trustSelfSignedCertificates = true;

    public void afterPropertiesSet() throws IOReactorException {
        if (this._classLoader != null) {
            TypeFactory typeFactory = TypeFactory.defaultInstance();
            this._objectMapper.setTypeFactory(typeFactory.withClassLoader(this._classLoader));
        }
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom();
        httpAsyncClientBuilder = httpAsyncClientBuilder.useSystemProperties();
        PoolingNHttpClientConnectionManager nHttpClientConnectionManager = this.getPoolingNHttpClientConnectionManager();
        httpAsyncClientBuilder.setConnectionManager((NHttpClientConnectionManager)nHttpClientConnectionManager);
        httpAsyncClientBuilder.setDefaultCredentialsProvider(this._getCredentialsProvider());
        this.setProxyHost(httpAsyncClientBuilder);
        try {
            CloseableHttpAsyncClient closeableHttpAsyncClient = httpAsyncClientBuilder.build();
            closeableHttpAsyncClient.start();
            this._asyncHttpClient = new AsyncHttpClient(closeableHttpAsyncClient, this._maxAttempts);
            this._idleConnectionMonitorThread = new IdleConnectionMonitorThread((NHttpClientConnectionManager)nHttpClientConnectionManager);
            this._idleConnectionMonitorThread.start();
            if (_log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Configured client for ");
                sb.append(this._protocol);
                sb.append("://");
                sb.append(this._hostName);
                sb.append(":");
                sb.append(this._hostPort);
                _log.debug((Object)sb.toString());
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to configure client", (Throwable)exception);
        }
    }

    @Override
    public void destroy() {
        if (this._asyncHttpClient != null) {
            try {
                this._asyncHttpClient.close();
            }
            catch (IOException ioException) {
                _log.error((Object)"Unable to close client", (Throwable)ioException);
            }
            this._asyncHttpClient = null;
        }
        if (this._idleConnectionMonitorThread != null) {
            this._idleConnectionMonitorThread.shutdown();
        }
    }

    @Override
    public String doDelete(String url, List<NameValuePair> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doDelete(url, parameters, Collections.emptyList());
    }

    @Override
    public String doDelete(String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (!parameters.isEmpty()) {
            String queryString = URLEncodedUtils.format(parameters, (Charset)_CHARSET);
            url = url + "?" + queryString;
        }
        this.log("DELETE", url, parameters, headers);
        HttpDelete httpDelete = new HttpDelete(url);
        this.addHeaders((HttpMessage)httpDelete, headers);
        return this.execute((HttpRequestBase)httpDelete);
    }

    @Override
    public String doDelete(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doDelete(url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    @Override
    public String doGet(String url, List<NameValuePair> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doGet(url, parameters, Collections.emptyList());
    }

    @Override
    public String doGet(String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (!parameters.isEmpty()) {
            String queryString = URLEncodedUtils.format(parameters, (Charset)_CHARSET);
            url = url + "?" + queryString;
        }
        this.log("GET", url, parameters, headers);
        HttpGet httpGet = new HttpGet(url);
        this.addHeaders((HttpMessage)httpGet, headers);
        return this.execute((HttpRequestBase)httpGet);
    }

    @Override
    public String doGet(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doGet(url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    @Override
    public <V, T> List<V> doGetToList(Class<T> clazz, String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doGet(url, parameters, headers);
        if (json == null) {
            return Collections.emptyList();
        }
        try {
            TypeFactory typeFactory = this._objectMapper.getTypeFactory();
            ArrayList list = new ArrayList();
            CollectionType javaType = typeFactory.constructCollectionType(list.getClass(), clazz);
            return (List)this._objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public <V, T> List<V> doGetToList(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        return this.doGetToList(clazz, url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    @Override
    public <T> T doGetToObject(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doGet(url, this._toNameValuePairs(parametersArray));
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public String doPost(String url, List<NameValuePair> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPost(url, parameters, Collections.emptyList());
    }

    @Override
    public String doPost(String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        this.log("POST", url, parameters, headers);
        HttpPost httpPost = new HttpPost(url);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(parameters, _CHARSET);
        this.addHeaders((HttpMessage)httpPost, headers);
        httpPost.setEntity((HttpEntity)httpEntity);
        return this.execute((HttpRequestBase)httpPost);
    }

    @Override
    public String doPost(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPost(url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    @Override
    public String doPostAsJSON(String url, Object object) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        try {
            String json = this._objectMapper.writeValueAsString(object);
            return this.doPostAsJSON(url, json);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(object);
        }
    }

    @Override
    public String doPostAsJSON(String url, String json) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPostAsJSON(url, json, Collections.emptyList());
    }

    @Override
    public String doPostAsJSON(String url, String json, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HttpPost httpPost = new HttpPost(url);
        this.addHeaders((HttpMessage)httpPost, headers);
        StringEntity stringEntity = new StringEntity(json, _CHARSET);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return this.execute((HttpRequestBase)httpPost);
    }

    @Override
    public <T> T doPostToObject(Class<T> clazz, String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doPost(url, parameters, headers);
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public <T> T doPostToObject(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doPost(url, parametersArray);
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public String doPut(String url, List<NameValuePair> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPut(url, parameters, Collections.emptyList());
    }

    @Override
    public String doPut(String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        this.log("PUT", url, parameters, headers);
        HttpPut httpPut = new HttpPut(url);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(parameters, _CHARSET);
        this.addHeaders((HttpMessage)httpPut, headers);
        httpPut.setEntity((HttpEntity)httpEntity);
        return this.execute((HttpRequestBase)httpPut);
    }

    @Override
    public String doPut(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPut(url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    @Override
    public <T> T doPutToObject(Class<T> clazz, String url, List<NameValuePair> parameters) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        return this.doPutToObject(clazz, url, parameters, Collections.emptyList());
    }

    @Override
    public <T> T doPutToObject(Class<T> clazz, String url, List<NameValuePair> parameters, List<NameValuePair> headers) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doPut(url, parameters, headers);
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public <T> T doPutToObject(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        return this.doPutToObject(clazz, url, this._toNameValuePairs(parametersArray), Collections.emptyList());
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    @Override
    public int getHostPort() {
        return this._hostPort;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    public String getProxyAuthType() {
        return this._proxyAuthType;
    }

    public String getProxyDomain() {
        return this._proxyDomain;
    }

    public String getProxyHostName() {
        return this._proxyHostName;
    }

    public int getProxyHostPort() {
        return this._proxyHostPort;
    }

    public String getProxyLogin() {
        return this._proxyLogin;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public String getProxyWorkstation() {
        return this._proxyWorkstation;
    }

    @Override
    public void registerModule(Module module) {
        this._objectMapper.registerModule(module);
    }

    @Override
    public void resetHttpClient() {
        this.destroy();
        try {
            this.afterPropertiesSet();
        }
        catch (IOReactorException ioReactorException) {
            _log.error((Throwable)ioReactorException);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    @Override
    public void setHostName(String hostName) {
        this._hostName = hostName;
    }

    @Override
    public void setHostPort(int hostPort) {
        this._hostPort = hostPort;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this._keyStore = keyStore;
    }

    @Override
    public void setLogin(String login) {
        this._login = login;
    }

    @Override
    public void setMaxAttempts(int maxAttempts) {
        this._maxAttempts = maxAttempts;
    }

    @Override
    public void setOAuthAccessSecret(String oAuthAccessSecret) {
        this._oAuthAccessSecret = oAuthAccessSecret;
    }

    @Override
    public void setOAuthAccessToken(String oAuthAccessToken) {
        this._oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public void setOAuthConsumerKey(String oAuthConsumerKey) {
        this._oAuthConsumerKey = oAuthConsumerKey;
    }

    @Override
    public void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this._oAuthConsumerSecret = oAuthConsumerSecret;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setProxyAuthType(String proxyAuthType) {
        this._proxyAuthType = proxyAuthType;
    }

    public void setProxyDomain(String proxyDomain) {
        this._proxyDomain = proxyDomain;
    }

    public void setProxyHostName(String proxyHostName) {
        this._proxyHostName = proxyHostName;
    }

    public void setProxyHostPort(int proxyHostPort) {
        this._proxyHostPort = proxyHostPort;
    }

    public void setProxyLogin(String proxyLogin) {
        this._proxyLogin = proxyLogin;
    }

    public void setProxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this._proxyWorkstation = proxyWorkstation;
    }

    @Override
    public void setTrustSelfSignedCertificates(boolean trustSelfSignedCertificates) {
        this._trustSelfSignedCertificates = trustSelfSignedCertificates;
    }

    protected BaseJSONWebServiceClientImpl() {
        this._objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this._objectMapper.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "class");
    }

    protected void addHeaders(HttpMessage httpMessage, List<NameValuePair> headers) {
        for (NameValuePair nameValuePair : headers) {
            httpMessage.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
        for (Map.Entry entry : this._headers.entrySet()) {
            httpMessage.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected String execute(HttpRequestBase httpRequestBase) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        this.signRequest(httpRequestBase);
        HttpHost httpHost = new HttpHost(this._hostName, this._hostPort, this._protocol);
        try {
            if (this._asyncHttpClient == null) {
                this.afterPropertiesSet();
            }
            Future<HttpResponse> future = null;
            if (!this.isNull(this._login) && !this.isNull(this._password)) {
                HttpClientContext httpClientContext = HttpClientContext.create();
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme authScheme = null;
                authScheme = !this.isNull(this._proxyHostName) ? new BasicScheme(ChallengeState.PROXY) : new BasicScheme(ChallengeState.TARGET);
                authCache.put(httpHost, (AuthScheme)authScheme);
                httpClientContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                future = this._asyncHttpClient.execute(httpHost, (HttpRequest)httpRequestBase, (HttpContext)httpClientContext);
            } else {
                future = this._asyncHttpClient.execute(httpHost, (HttpRequest)httpRequestBase);
            }
            HttpResponse httpResponse = future.get();
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Server returned status " + statusCode));
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (statusCode == 204 || (httpEntity == null || httpEntity.getContentLength() == 0L) && this._isStatus2XX(statusCode)) {
                String string = null;
                return string;
            }
            String content = EntityUtils.toString((HttpEntity)httpEntity, (Charset)_CHARSET);
            if (httpEntity.getContentType() != null && this._isApplicationJSONContentType(httpEntity)) {
                content = this.updateJSON(content);
            }
            if (this._isStatus2XX(statusCode)) {
                String string = content;
                return string;
            }
            try {
                if (statusCode == 400 || statusCode == 403 || statusCode == 405 || statusCode == 406 || statusCode == 404) {
                    throw new JSONWebServiceInvocationException(content, statusCode);
                }
                if (statusCode == 401) {
                    throw new JSONWebServiceTransportException.AuthenticationFailure("Not authorized to access JSON web service " + content);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Server returned status ");
                sb.append(statusCode);
                sb.append(" and content ");
                sb.append(content);
                throw new JSONWebServiceTransportException.CommunicationFailure(sb.toString(), statusCode);
            }
            catch (ExecutionException executionException) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, executionException);
            }
            catch (InterruptedException interruptedException) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, interruptedException);
            }
            catch (IOException ioException) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, ioException);
            }
        }
        finally {
            httpRequestBase.releaseConnection();
        }
    }

    protected String getExceptionMessage(String json) {
        int exceptionMessageStart = json.indexOf("exception\":\"") + 12;
        int exceptionMessageEnd = json.indexOf("\"", exceptionMessageStart);
        return json.substring(exceptionMessageStart, exceptionMessageEnd);
    }

    protected PoolingNHttpClientConnectionManager getPoolingNHttpClientConnectionManager() throws IOReactorException {
        PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(), null, this.getSchemeIOSessionStrategyRegistry(), null, null, 60000L, TimeUnit.MILLISECONDS);
        poolingNHttpClientConnectionManager.setMaxTotal(20);
        return poolingNHttpClientConnectionManager;
    }

    protected Registry<SchemeIOSessionStrategy> getSchemeIOSessionStrategyRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        if (this._keyStore == null) {
            registryBuilder.register("https", (Object)SSLIOSessionStrategy.getSystemDefaultStrategy());
        } else {
            registryBuilder.register("https", (Object)this.getSSLIOSessionStrategy());
        }
        return registryBuilder.build();
    }

    protected SSLIOSessionStrategy getSSLIOSessionStrategy() {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        SSLContext sslContext = null;
        try {
            sslContext = sslContextBuilder.build();
            sslContext.init(null, new TrustManager[]{new X509TrustManagerImpl(this._keyStore, this._trustSelfSignedCertificates)}, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        String[] httpsProtocols = this._split(System.getProperty("https.protocols"));
        String[] cipherSuites = this._split(System.getProperty("https.cipherSuites"));
        return new SSLIOSessionStrategy(sslContext, httpsProtocols, cipherSuites, SSLIOSessionStrategy.getDefaultHostnameVerifier());
    }

    protected int getStatus(String json) {
        Matcher statusMatcher = _statusPattern.matcher(json);
        if (!statusMatcher.find()) {
            return 0;
        }
        return GetterUtil.getInteger((String)statusMatcher.group(1));
    }

    protected boolean isNull(String s) {
        return s == null || s.equals("");
    }

    protected void log(String httpCommand, String url, List<NameValuePair> parameters, List<NameValuePair> headers) {
        if (!_log.isTraceEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(12 + headers.size() * 4 + parameters.size() * 4 + 2);
        sb.append("Sending ");
        sb.append(httpCommand);
        sb.append(" request to ");
        sb.append(this._login);
        sb.append("@");
        sb.append(this._hostName);
        sb.append(url);
        sb.append("\n");
        sb.append("HTTP Headers: ");
        this._update(sb, headers);
        sb.append("\n");
        sb.append("HTTP parameters: ");
        this._update(sb, parameters);
        sb.append("\n");
        _log.trace((Object)sb.toString());
    }

    protected void setProxyHost(HttpAsyncClientBuilder httpClientBuilder) {
        if (this._proxyHostName == null || this._proxyHostName.equals("")) {
            return;
        }
        httpClientBuilder.setProxy(new HttpHost(this._proxyHostName, this._proxyHostPort));
        httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
    }

    protected abstract void signRequest(HttpRequestBase var1) throws JSONWebServiceTransportException.SigningFailure;

    protected String updateJSON(String json) throws JSONWebServiceInvocationException {
        if (json == null || json.equals("") || json.equals("{}") || json.equals("[]")) {
            return null;
        }
        Matcher matcher = _errorMessagePattern.matcher(json);
        if (matcher.find()) {
            throw new JSONWebServiceInvocationException(json, GetterUtil.getInteger((String)matcher.group(2)));
        }
        if (json.contains("exception\":\"")) {
            throw new JSONWebServiceInvocationException(this.getExceptionMessage(json), this.getStatus(json));
        }
        return json;
    }

    private CredentialsProvider _getCredentialsProvider() {
        StringBuilder sb;
        if ((this.isNull(this._login) || this.isNull(this._password)) && (this.isNull(this._proxyLogin) || this.isNull(this._proxyPassword))) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (!this.isNull(this._login)) {
            credentialsProvider.setCredentials(new AuthScope(this._hostName, this._hostPort), (Credentials)new UsernamePasswordCredentials(this._login, this._password));
            if (_log.isDebugEnabled()) {
                sb = new StringBuilder();
                sb.append("Basic credentials are used for ");
                sb.append(this._hostName);
                sb.append(":");
                sb.append(this._hostPort);
                _log.debug((Object)sb.toString());
            }
        }
        if (this.isNull(this._proxyLogin)) {
            return credentialsProvider;
        }
        credentialsProvider.setCredentials(new AuthScope(this._proxyHostName, this._proxyHostPort), this._getProxyCredentials());
        if (_log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Proxy credentials are used for ");
            sb.append(this._hostName);
            sb.append(":");
            sb.append(this._hostPort);
            _log.debug((Object)sb.toString());
        }
        return credentialsProvider;
    }

    private JSONWebServiceSerializeException _getJSONWebServiceSerializeException(Object object) {
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to serialize object with type ");
        sb.append(object.getClass());
        return new JSONWebServiceSerializeException(sb.toString());
    }

    private <T> JSONWebServiceSerializeException _getJSONWebServiceSerializeException(String json, Class<T> clazz) {
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to deserialize ");
        sb.append(json);
        sb.append(" into object with type ");
        sb.append(clazz.getName());
        return new JSONWebServiceSerializeException(sb.toString());
    }

    private Credentials _getProxyCredentials() {
        if ("ntlm".equalsIgnoreCase(this._proxyAuthType)) {
            return new NTCredentials(this._proxyLogin, this._proxyPassword, this._proxyWorkstation, this._proxyDomain);
        }
        return new UsernamePasswordCredentials(this._proxyLogin, this._proxyPassword);
    }

    private boolean _isApplicationJSONContentType(HttpEntity httpEntity) {
        Header contentTypeHeader = httpEntity.getContentType();
        String contentTypeHeaderValue = contentTypeHeader.getValue();
        return contentTypeHeaderValue.contains("application/json");
    }

    private boolean _isBlank(String s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean _isStatus2XX(int statusCode) {
        return statusCode == 200 || statusCode == 201 || statusCode == 202 || statusCode == 203 || statusCode == 204;
    }

    private String[] _split(String s) {
        if (this._isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private List<NameValuePair> _toNameValuePairs(String ... keyValuesArray) {
        if (keyValuesArray == null || keyValuesArray.length == 0) {
            return Collections.emptyList();
        }
        if (keyValuesArray.length % 2 == 1) {
            throw new IllegalArgumentException("Expected even number of variable arguments");
        }
        LinkedList<NameValuePair> nameValuePairs = new LinkedList<NameValuePair>();
        for (int i = 0; i < keyValuesArray.length; i += 2) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(keyValuesArray[i], keyValuesArray[i + 1]));
        }
        return nameValuePairs;
    }

    private void _update(StringBuilder stringBuilder, List<NameValuePair> nameValuePairs) {
        Iterator<NameValuePair> iterator = nameValuePairs.iterator();
        stringBuilder.append("{");
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = iterator.next();
            stringBuilder.append(nameValuePair.getName());
            stringBuilder.append("=");
            stringBuilder.append(nameValuePair.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
    }
}

