/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.web.service.client.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.HttpContext;

public class AsyncHttpClient
implements Closeable {
    private static final Log _log = LogFactoryUtil.getLog(AsyncHttpClient.class);
    private final CloseableHttpAsyncClient _closeableHttpAsyncClient;
    private final int _maxAttempts;

    public AsyncHttpClient(CloseableHttpAsyncClient closeableHttpAsyncClient, int maxAttempts) {
        this._closeableHttpAsyncClient = closeableHttpAsyncClient;
        this._maxAttempts = maxAttempts < 1 ? 1 : maxAttempts;
    }

    @Override
    public void close() throws IOException {
        this._closeableHttpAsyncClient.close();
    }

    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest) {
        return this.execute(httpHost, httpRequest, (HttpContext)HttpClientContext.create());
    }

    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        for (int i = 1; i <= this._maxAttempts; ++i) {
            if (this._maxAttempts == 1 || this._maxAttempts == i) {
                return this._closeableHttpAsyncClient.execute(httpHost, httpRequest, httpContext, null);
            }
            try {
                Future httpResponseFuture = this._closeableHttpAsyncClient.execute(httpHost, httpRequest, httpContext, null);
                httpResponseFuture.get();
                return httpResponseFuture;
            }
            catch (Exception exception) {
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("Unable to execute HTTP request in attempt " + i), (Throwable)exception);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    _log.error((Object)"Interrupted", (Throwable)interruptedException);
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Aborting executing after " + i + " attempts"));
                }
                continue;
            }
        }
        throw new RuntimeException("Unable to execute HTTP request after " + this._maxAttempts + " attempts");
    }
}

