/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.web.service.client.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.concurrent.TimeUnit;
import org.apache.http.nio.conn.NHttpClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private static final Log _log = LogFactoryUtil.getLog(IdleConnectionMonitorThread.class);
    private final NHttpClientConnectionManager _nHttpClientConnectionManager;
    private volatile boolean _shutdown;

    public IdleConnectionMonitorThread(NHttpClientConnectionManager nHttpClientConnectionManager) {
        this._nHttpClientConnectionManager = nHttpClientConnectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this._shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(5000L);
                    this._nHttpClientConnectionManager.closeExpiredConnections();
                    this._nHttpClientConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            if (!_log.isDebugEnabled()) return;
            _log.debug((Throwable)interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

