/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.web.service.client.internal;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerImpl
implements X509TrustManager {
    private final X509TrustManager _defaultX509TrustManager;
    private final X509TrustManager _extraX509TrustManager;
    private final boolean _trustSelfSignedCertificates;

    public X509TrustManagerImpl() {
        try {
            this._defaultX509TrustManager = this._getX509TrustManager(null);
            this._extraX509TrustManager = null;
            this._trustSelfSignedCertificates = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public X509TrustManagerImpl(KeyStore keyStore, boolean trustSelfSignedCertificates) {
        try {
            this._defaultX509TrustManager = this._getX509TrustManager(null);
            this._extraX509TrustManager = keyStore != null ? this._getX509TrustManager(keyStore) : null;
            this._trustSelfSignedCertificates = trustSelfSignedCertificates;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (!this._trustSelfSignedCertificates || x509Certificates.length != 1) {
            try {
                this._defaultX509TrustManager.checkClientTrusted(x509Certificates, authType);
            }
            catch (CertificateException certificateException) {
                if (this._extraX509TrustManager != null) {
                    this._extraX509TrustManager.checkClientTrusted(x509Certificates, authType);
                }
                throw certificateException;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (!this._trustSelfSignedCertificates || x509Certificates.length != 1) {
            try {
                this._defaultX509TrustManager.checkServerTrusted(x509Certificates, authType);
            }
            catch (CertificateException certificateException) {
                if (this._extraX509TrustManager != null) {
                    this._extraX509TrustManager.checkServerTrusted(x509Certificates, authType);
                }
                throw certificateException;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this._extraX509TrustManager != null) {
            return (X509Certificate[])ArrayUtil.append((Object[])this._defaultX509TrustManager.getAcceptedIssuers(), (Object[])this._extraX509TrustManager.getAcceptedIssuers());
        }
        return this._defaultX509TrustManager.getAcceptedIssuers();
    }

    private X509TrustManager _getX509TrustManager(KeyStore keyStore) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }
}

