/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsp.engine.internal;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.jsp.engine.internal.delegate.CheckEnabledServletDelegate;
import com.liferay.portal.jsp.engine.internal.delegate.JspConfigDescriptorServletContextDelegate;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.util.PropsImpl;
import com.liferay.shielded.container.Ordered;
import com.liferay.shielded.container.ShieldedContainerInitializer;
import com.liferay.taglib.servlet.JspFactorySwapper;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanner;

@Ordered(value=1)
public class JSPEngineShieldedContainerInitializer
implements ShieldedContainerInitializer {
    public void initialize(ServletContext servletContext) throws ServletException {
        File shieldedContainerLib = new File(servletContext.getRealPath("/WEB-INF/shielded-container-lib"));
        try {
            Object path = shieldedContainerLib.getCanonicalPath();
            path = StringUtil.replace((String)path, (char)'\\', (char)'/');
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            System.setProperty("liferay.shielded.container.lib.portal.dir", (String)path);
        }
        catch (IOException ioException) {
            throw new ServletException((Throwable)ioException);
        }
        ClassLoaderPool.register((String)"ShieldedContainerClassLoader", (ClassLoader)servletContext.getClassLoader());
        PropsUtil.setProps((Props)new PropsImpl());
        StandardJarScanner jarScanner = new StandardJarScanner();
        jarScanner.setJarScanFilter(new JarScanFilter(){

            public boolean check(JarScanType jarScanType, String jarName) {
                return false;
            }

            public boolean isSkipAll() {
                return true;
            }
        });
        servletContext.setAttribute(JarScanner.class.getName(), (Object)jarScanner);
        JasperInitializer jasperInitializer = new JasperInitializer();
        jasperInitializer.onStartup(null, (ServletContext)ProxyUtil.newDelegateProxyInstance((ClassLoader)servletContext.getClassLoader(), ServletContext.class, (Object)new JspConfigDescriptorServletContextDelegate(servletContext), (Object)servletContext));
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            JspFactorySwapper.swap();
            return null;
        });
        Map initParameters = PropertiesUtil.toMap((Properties)PropsUtil.getProperties((String)"jsp.engine.", (boolean)true));
        JspServlet jspServlet = new JspServlet();
        long checkInterval = GetterUtil.getLong((String)((String)initParameters.get("checkInterval")));
        if (GetterUtil.getBoolean((String)((String)initParameters.get("development")))) {
            checkInterval = 0L;
        }
        Object portalJSPServlet = checkInterval > 0L ? (Servlet)ProxyUtil.newDelegateProxyInstance((ClassLoader)servletContext.getClassLoader(), Servlet.class, (Object)new CheckEnabledServletDelegate(jspServlet, servletContext, checkInterval), (Object)jspServlet) : jspServlet;
        ServletRegistration.Dynamic servletDynamic = servletContext.addServlet("Portal Jasper Servlet", (Servlet)portalJSPServlet);
        servletDynamic.setInitParameters(initParameters);
        servletDynamic.setLoadOnStartup(1);
        if (ServerDetector.isTomcat()) {
            servletDynamic.addMapping(new String[]{"*.jsp", "*.jspx"});
        } else {
            FilterRegistration.Dynamic filterDynamic = servletContext.addFilter("Portal Jasper Filter", new Filter(){
                final /* synthetic */ Servlet val$portalJSPServlet;
                final /* synthetic */ ServletContext val$servletContext;
                {
                    this.val$portalJSPServlet = servlet;
                    this.val$servletContext = servletContext;
                }

                public void destroy() {
                }

                public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
                    if (servletRequest instanceof HttpServletRequest) {
                        this.val$portalJSPServlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                            public ServletContext getServletContext() {
                                return val$servletContext;
                            }
                        }, servletResponse);
                    } else {
                        this.val$portalJSPServlet.service((ServletRequest)new ServletRequestWrapper(servletRequest){

                            public ServletContext getServletContext() {
                                return val$servletContext;
                            }
                        }, servletResponse);
                    }
                }

                public void init(FilterConfig filterConfig) {
                }
            });
            filterDynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"*.jsp", "*.jspx"});
        }
    }
}

