/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsp.engine.internal.compiler;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.servlet.JspServletWrapper;

public class BridgeCompiler
extends Compiler {
    private static final Method _generateClassMethod;
    private static volatile Supplier<Compiler> _supplier;
    private final Compiler _compiler;

    public static void init(Supplier<Compiler> supplier) {
        _supplier = supplier;
    }

    public BridgeCompiler() {
        Supplier<Compiler> supplier = _supplier;
        if (supplier == null) {
            throw new IllegalStateException("Compiler supplier is null");
        }
        this._compiler = supplier.get();
    }

    public void compile(boolean compileClass) throws Exception {
        this._compiler.compile(compileClass);
    }

    public void init(JspCompilationContext jspCompilationContext, JspServletWrapper jspServletWrapper) {
        this._compiler.init(jspCompilationContext, jspServletWrapper);
    }

    public boolean isOutDated() {
        return this._compiler.isOutDated();
    }

    public void removeGeneratedFiles() {
        this._compiler.removeGeneratedFiles();
    }

    protected void generateClass(Map<String, SmapStratum> smaps) throws Exception {
        _generateClassMethod.invoke((Object)this._compiler, smaps);
    }

    static {
        try {
            _generateClassMethod = Compiler.class.getDeclaredMethod("generateClass", Map.class);
            _generateClassMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

