/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsp.engine.internal.delegate;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.jasper.servlet.JspServlet;

public class CheckEnabledServletDelegate {
    private final long _checkInterval;
    private final JspServlet _jspServlet;
    private ScheduledExecutorService _scheduledExecutorService;
    private final ServletContext _servletContext;

    public CheckEnabledServletDelegate(JspServlet jspServlet, ServletContext servletContext, long checkInterval) {
        this._jspServlet = jspServlet;
        this._servletContext = servletContext;
        this._checkInterval = checkInterval;
    }

    public void destroy() {
        this._scheduledExecutorService.shutdownNow();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this._jspServlet.init(servletConfig);
        this._scheduledExecutorService = new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable, "Portal Jasper Servlet Background Compiler Thread");
            thread.setContextClassLoader(this._servletContext.getClassLoader());
            thread.setDaemon(true);
            return thread;
        });
        this._scheduledExecutorService.scheduleWithFixedDelay(() -> ((JspServlet)this._jspServlet).periodicEvent(), this._checkInterval, this._checkInterval, TimeUnit.SECONDS);
    }
}

