/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal;

import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.persistence.InMemoryOnlyConfigurationThreadLocal;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.k8s.agent.configuration.PortalK8sAgentConfiguration;
import com.liferay.portal.k8s.agent.custodian.VirtualInstanceCustodian;
import com.liferay.portal.k8s.agent.internal.thread.local.AgentPortalK8sThreadLocal;
import com.liferay.portal.k8s.agent.mutator.PortalK8sConfigurationPropertiesMutator;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.felix.configurator.impl.json.BinUtil;
import org.apache.felix.configurator.impl.json.BinaryManager;
import org.apache.felix.configurator.impl.json.JSONUtil;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigurationFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.k8s.agent.configuration.PortalK8sAgentConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"portalK8sConfigurationPropertiesMutators.cardinality.minimum:Integer=3"}, service={PortalK8sConfigMapModifier.class, VirtualInstanceCustodian.class})
public class AgentPortalK8sConfigMapModifier
implements PortalK8sConfigMapModifier,
VirtualInstanceCustodian {
    private static final String _ERROR_MESSAGE = "Configured service account does not have access. Service account may have been revoked.";
    private static final String _FILE_EXTENSION = ".client-extension-config.json";
    private static final Log _log = LogFactoryUtil.getLog(AgentPortalK8sConfigMapModifier.class);
    private final Bundle _bundle;
    private final ClusterExecutor _clusterExecutor;
    private final ClusterMasterExecutor _clusterMasterExecutor;
    private final ConfigurationAdmin _configurationAdmin;
    private final KubernetesClient _kubernetesClient;
    private final PortalK8sAgentConfiguration _portalK8sAgentConfiguration;
    private final List<PortalK8sConfigurationPropertiesMutator> _portalK8sConfigurationPropertiesMutators;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final SharedIndexInformer<ConfigMap> _sharedIndexInformer;

    @Activate
    public AgentPortalK8sConfigMapModifier(BundleContext bundleContext, @Reference ClusterExecutor clusterExecutor, @Reference ClusterMasterExecutor clusterMasterExecutor, @Reference ConfigurationAdmin configurationAdmin, @Reference(target="(config.plugin.id=org.apache.felix.configadmin.plugin.interpolation)") ConfigurationPlugin configurationPlugin, @Reference(name="portalK8sConfigurationPropertiesMutators", policyOption=ReferencePolicyOption.GREEDY) List<PortalK8sConfigurationPropertiesMutator> portalK8sConfigurationPropertiesMutators, Map<String, Object> properties) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Initializing K8s agent with " + properties));
        }
        this._clusterExecutor = clusterExecutor;
        this._clusterMasterExecutor = clusterMasterExecutor;
        this._configurationAdmin = configurationAdmin;
        this._portalK8sConfigurationPropertiesMutators = portalK8sConfigurationPropertiesMutators;
        this._bundle = bundleContext.getBundle();
        this._portalK8sAgentConfiguration = (PortalK8sAgentConfiguration)ConfigurableUtil.createConfigurable(PortalK8sAgentConfiguration.class, properties);
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this._kubernetesClient = new DefaultKubernetesClient(this._toConfig(this._portalK8sAgentConfiguration));
        this._sharedIndexInformer = this._toSharedIndexInformer(this._kubernetesClient, this._portalK8sAgentConfiguration);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Initialized K8s agent");
        }
    }

    public void clean(List<String> companyWebIds) {
        ConfigMapList configMapList = (ConfigMapList)((FilterWatchListDeletable)this._kubernetesClient.configMaps().withLabel("lxc.liferay.com/metadataType", "dxp")).list();
        for (ConfigMap configMap : configMapList.getItems()) {
            ObjectMeta objectMeta = configMap.getMetadata();
            Map<String, String> labels = objectMeta.getLabels();
            String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
            if (!Validator.isNull((String)virtualInstanceId) && companyWebIds.contains(virtualInstanceId)) continue;
            this._kubernetesClient.configMaps().delete(configMap);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Deleted custodian " + configMap));
        }
    }

    public PortalK8sConfigMapModifier.Result modifyConfigMap(Consumer<PortalK8sConfigMapModifier.ConfigMapModel> configMapModelConsumer, String configMapName) {
        PortalK8sConfigMapModifier.Result result = this._modifyConfigMap(configMapModelConsumer, configMapName);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Config map ", configMapName, " ", result}));
        }
        return result;
    }

    @Deactivate
    protected void deactivate() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deactivating K8s agent");
        }
        this._sharedIndexInformer.close();
        this._kubernetesClient.close();
        this._scheduledExecutorService.shutdown();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deactivated K8s agent");
        }
    }

    private void _add(ConfigMap configMap) {
        Map<String, String> data;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding config map " + configMap.toString()));
        }
        if ((data = configMap.getData()) == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Data is null for config map " + configMap));
            }
            return;
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            try {
                this._processConfigurations(configMap, entry.getKey(), entry.getValue());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private Map<String, String> _copy(Map<String, String> annotations) {
        return new TreeMap<String, String>(this._getMap(annotations));
    }

    private void _delete(ConfigMap configMap) {
        Map<String, String> data;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deleting config map " + configMap));
        }
        if ((data = configMap.getData()) == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Data is null for config map " + configMap));
            }
            return;
        }
        Configuration[] configurations = null;
        try {
            ObjectMeta objectMeta = configMap.getMetadata();
            configurations = this._configurationAdmin.listConfigurations("(.k8s.config.uid=" + objectMeta.getUid() + ")");
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (configurations == null) {
            return;
        }
        for (Configuration configuration : configurations) {
            try {
                configuration.delete();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private Configuration _getConfiguration(String pid) throws Exception {
        int index;
        if (pid.endsWith(_FILE_EXTENSION)) {
            pid = pid.substring(0, pid.length() - _FILE_EXTENSION.length());
        }
        if ((index = pid.indexOf(126)) <= 0 && (index = pid.indexOf(95)) <= 0) {
            index = pid.indexOf(45);
        }
        if (index > 0) {
            String name = pid.substring(index + 1);
            pid = pid.substring(0, index);
            return this._configurationAdmin.getFactoryConfiguration(pid, name, "?");
        }
        return this._configurationAdmin.getConfiguration(pid, "?");
    }

    private Map<String, String> _getMap(Map<String, String> map) {
        if (map == null) {
            map = new TreeMap<String, String>();
        }
        return map;
    }

    private String _getVirtualInstancePid(Config config, String virtualInstanceId) {
        String pid = config.getPid();
        String factoryPid = ConfigurationFactoryUtil.getFactoryPidFromPid((String)pid);
        if (factoryPid == null) {
            return pid;
        }
        return StringBundler.concat((String[])new String[]{pid, "/", virtualInstanceId});
    }

    private PortalK8sConfigMapModifier.Result _modifyConfigMap(Consumer<PortalK8sConfigMapModifier.ConfigMapModel> configMapModelConsumer, String configMapName) {
        if (this._clusterMasterExecutor.isEnabled()) {
            if (_log.isDebugEnabled()) {
                ClusterNode localClusterNode = this._clusterExecutor.getLocalClusterNode();
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Current node ", localClusterNode.getClusterNodeId(), " is ", !this._clusterMasterExecutor.isMaster() ? "not " : "", "master"}));
            }
            if (AgentPortalK8sThreadLocal.isExecuteOnCurrentNode()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Execute on current node");
                }
            } else if (!this._clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Execute on master only");
                }
                return PortalK8sConfigMapModifier.Result.UNCHANGED;
            }
        }
        Objects.requireNonNull(configMapModelConsumer, "Config map model consumer is null");
        this._validateConfigMapName(configMapName);
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this._kubernetesClient.configMaps().inNamespace(this._portalK8sAgentConfiguration.namespace())).withName(configMapName)).get();
        if (configMap != null) {
            ObjectMeta objectMeta = configMap.getMetadata();
            Map<String, String> originalAnnotations = this._getMap(objectMeta.getAnnotations());
            final Map<String, String> annotations = this._copy(originalAnnotations);
            Map<String, String> originalBinaryData = this._getMap(configMap.getBinaryData());
            final Map<String, String> binaryData = this._copy(originalBinaryData);
            Map<String, String> originalData = this._getMap(configMap.getData());
            final Map<String, String> data = this._copy(originalData);
            Map<String, String> originalLabels = this._getMap(objectMeta.getLabels());
            final Map<String, String> labels = this._copy(originalLabels);
            configMapModelConsumer.accept(new PortalK8sConfigMapModifier.ConfigMapModel(){

                public Map<String, String> annotations() {
                    return annotations;
                }

                public Map<String, String> binaryData() {
                    return binaryData;
                }

                public Map<String, String> data() {
                    return data;
                }

                public Map<String, String> labels() {
                    return labels;
                }
            });
            if (binaryData.isEmpty() && data.isEmpty()) {
                this._kubernetesClient.configMaps().delete(configMap);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Deleted " + configMap));
                }
                return PortalK8sConfigMapModifier.Result.DELETED;
            }
            if (!(Objects.equals(annotations, originalAnnotations) && Objects.equals(binaryData, originalBinaryData) && Objects.equals(data, originalData) && Objects.equals(labels, originalLabels))) {
                this._validateLabels(configMapName, labels);
                configMap.setData(binaryData);
                configMap.setData(data);
                objectMeta.setAnnotations(annotations);
                objectMeta.setLabels(labels);
                configMap = ((Resource)this._kubernetesClient.configMaps().withName(configMapName)).createOrReplace(configMap);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Updated " + configMap));
                }
                return PortalK8sConfigMapModifier.Result.UPDATED;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unchanged " + configMap));
            }
            return PortalK8sConfigMapModifier.Result.UNCHANGED;
        }
        final TreeMap<String, String> annotations = new TreeMap<String, String>();
        final TreeMap<String, String> binaryData = new TreeMap<String, String>();
        final TreeMap<String, String> data = new TreeMap<String, String>();
        final TreeMap<String, String> labels = new TreeMap<String, String>();
        configMapModelConsumer.accept(new PortalK8sConfigMapModifier.ConfigMapModel(){

            public Map<String, String> annotations() {
                return annotations;
            }

            public Map<String, String> binaryData() {
                return binaryData;
            }

            public Map<String, String> data() {
                return data;
            }

            public Map<String, String> labels() {
                return labels;
            }
        });
        if (binaryData.isEmpty() && data.isEmpty()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Config map does not exist and no data was supplied ", "for ", configMapName, " resulting in no change"}));
            }
            return PortalK8sConfigMapModifier.Result.UNCHANGED;
        }
        this._validateLabels(configMapName, labels);
        ConfigMapBuilder configMapBuilder = new ConfigMapBuilder();
        configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)configMapBuilder.withNewMetadata().withNamespace(this._portalK8sAgentConfiguration.namespace())).withName(configMapName)).addToAnnotations(annotations)).addToLabels(labels)).endMetadata()).addToBinaryData(binaryData)).addToData(data)).build();
        configMap = ((Resource)this._kubernetesClient.configMaps().withName(configMapName)).createOrReplace(configMap);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Created " + configMap));
        }
        return PortalK8sConfigMapModifier.Result.CREATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processConfiguration(Config config, ObjectMeta objectMeta) throws Exception {
        Map<String, String> labels = this._getMap(objectMeta.getLabels());
        String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
        if (virtualInstanceId == null) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Config map labels must contain the key ", "\"dxp.lxc.liferay.com/virtualInstanceId\" whose value is ", "the web ID of the target virtual instance"}));
        }
        String virtualInstancePid = this._getVirtualInstancePid(config, virtualInstanceId);
        try {
            InMemoryOnlyConfigurationThreadLocal.setInMemoryOnly((boolean)true);
            Object configuration = null;
            Object[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(.k8s.config.key=", virtualInstancePid, ")"}));
            if (ArrayUtil.isNotEmpty((Object[])configurations)) {
                configuration = configurations[0];
                Dictionary properties = configuration.getProperties();
                if (Objects.equals(properties.get(".k8s.config.resource.version"), objectMeta.getResourceVersion())) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Configuration and Kubernetes resource versions are identical");
                    }
                    return;
                }
            } else {
                configuration = this._getConfiguration(virtualInstancePid);
            }
            Set configurationAttributes = configuration.getAttributes();
            if (configurationAttributes.contains(Configuration.ConfigurationAttribute.READ_ONLY)) {
                configuration.removeAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
            }
            Map<String, String> annotations = this._getMap(objectMeta.getAnnotations());
            Dictionary<String, Object> properties = config.getProperties();
            for (PortalK8sConfigurationPropertiesMutator portalK8sConfigurationPropertiesMutator : this._portalK8sConfigurationPropertiesMutators) {
                portalK8sConfigurationPropertiesMutator.mutateConfigurationProperties(annotations, labels, properties);
            }
            properties.put(".k8s.config.key", virtualInstancePid);
            properties.put(".k8s.config.resource.version", objectMeta.getResourceVersion());
            properties.put(".k8s.config.uid", objectMeta.getUid());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Processed configuration " + properties));
            }
            configuration.updateIfDifferent(properties);
            configuration.addAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
        }
        finally {
            InMemoryOnlyConfigurationThreadLocal.setInMemoryOnly((boolean)false);
        }
    }

    private void _processConfigurations(ConfigMap configMap, final String fileName, String json) throws Exception {
        if (!fileName.endsWith(_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Invalid file " + fileName);
        }
        JSONUtil.Report report = new JSONUtil.Report();
        BinaryManager binaryManager = new BinaryManager(new BinUtil.ResourceProvider(){

            @Override
            public Enumeration<URL> findEntries(String path, String pattern) {
                return Collections.emptyEnumeration();
            }

            @Override
            public long getBundleId() {
                return AgentPortalK8sConfigMapModifier.this._bundle.getBundleId();
            }

            @Override
            public URL getEntry(String path) {
                return null;
            }

            @Override
            public String getIdentifier() {
                return fileName;
            }
        }, report);
        ConfigurationFile configurationFile = JSONUtil.readJSON(binaryManager, fileName, new URL("file", null, fileName), this._bundle.getBundleId(), json, report);
        for (String error : report.errors) {
            _log.error((Object)error);
        }
        for (String warning : report.warnings) {
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)warning);
        }
        if (configurationFile == null) {
            return;
        }
        for (Config config : configurationFile.getConfigurations()) {
            try {
                this._processConfiguration(config, configMap.getMetadata());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private void _run(Runnable runnable2) {
        ClusterNode localClusterNode = this._clusterExecutor.getLocalClusterNode();
        if (this._clusterMasterExecutor.isEnabled() && !this._clusterMasterExecutor.isMaster()) {
            this._scheduledExecutorService.schedule(() -> {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Defer execution on cluster node " + localClusterNode.getClusterNodeId()));
                }
                runnable2.run();
            }, this._portalK8sAgentConfiguration.deferSecondaryNodeMillis(), TimeUnit.MILLISECONDS);
        } else {
            if (localClusterNode != null && _log.isDebugEnabled()) {
                _log.debug((Object)("Execute on master node " + localClusterNode.getClusterNodeId()));
            }
            runnable2.run();
        }
    }

    private io.fabric8.kubernetes.client.Config _toConfig(PortalK8sAgentConfiguration portalK8sAgentConfiguration) {
        io.fabric8.kubernetes.client.Config config = io.fabric8.kubernetes.client.Config.empty();
        Map<Integer, String> errorMessages = config.getErrorMessages();
        errorMessages.put(401, _ERROR_MESSAGE);
        errorMessages.put(403, _ERROR_MESSAGE);
        config.setCaCertData(portalK8sAgentConfiguration.caCertData());
        String protocol = "http";
        if (portalK8sAgentConfiguration.apiServerSSL()) {
            protocol = "https";
        }
        config.setMasterUrl(StringBundler.concat((Object[])new Object[]{protocol, "://", portalK8sAgentConfiguration.apiServerHost(), ":", portalK8sAgentConfiguration.apiServerPort(), "/"}));
        config.setNamespace(portalK8sAgentConfiguration.namespace());
        config.setOauthToken(portalK8sAgentConfiguration.saToken());
        io.fabric8.kubernetes.client.Config.configFromSysPropsOrEnvVars(config);
        return config;
    }

    private SharedIndexInformer<ConfigMap> _toSharedIndexInformer(KubernetesClient kubernetesClient, PortalK8sAgentConfiguration portalK8sAgentConfiguration) {
        SharedInformerFactory sharedInformerFactory = kubernetesClient.informers();
        sharedInformerFactory.addSharedInformerEventListener(new SharedInformerEventListener(){

            @Override
            public void onException(Exception exception) {
                _log.error((Throwable)exception);
            }
        });
        return ((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(portalK8sAgentConfiguration.namespace())).withLabel(portalK8sAgentConfiguration.labelSelector())).inform(new ResourceEventHandler<ConfigMap>(){

            @Override
            public void onAdd(ConfigMap configMap) {
                AgentPortalK8sConfigMapModifier.this._run(() -> AgentPortalK8sConfigMapModifier.this._add(configMap));
            }

            @Override
            public void onDelete(ConfigMap configMap, boolean deletedFinalStateUnknown) {
                AgentPortalK8sConfigMapModifier.this._run(() -> AgentPortalK8sConfigMapModifier.this._delete(configMap));
            }

            @Override
            public void onUpdate(ConfigMap oldConfigMap, ConfigMap newConfigMap) {
                AgentPortalK8sConfigMapModifier.this._run(() -> AgentPortalK8sConfigMapModifier.this._update(oldConfigMap, newConfigMap));
            }
        });
    }

    private void _update(ConfigMap oldConfigMap, ConfigMap newConfigMap) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Updating config map ", oldConfigMap, " to ", newConfigMap}));
        }
        Map<String, String> data = newConfigMap.getData();
        ObjectMeta objectMeta = newConfigMap.getMetadata();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                try {
                    this._processConfigurations(newConfigMap, entry.getKey(), entry.getValue());
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        Configuration[] configurations = null;
        try {
            ObjectMeta oldObjectMeta = oldConfigMap.getMetadata();
            if (Objects.equals(oldObjectMeta.getResourceVersion(), objectMeta.getResourceVersion())) {
                return;
            }
            configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(&(.k8s.config.resource.version=", oldObjectMeta.getResourceVersion(), ")(.k8s.config.uid=", objectMeta.getUid(), "))"}));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (configurations == null) {
            return;
        }
        for (void var9_11 : configurations) {
            try {
                var9_11.delete();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private void _validateConfigMapName(String configMapName) {
        Objects.requireNonNull(configMapName, "Config map name is null");
        if (!configMapName.endsWith("-lxc-dxp-metadata") && !configMapName.endsWith("-lxc-ext-init-metadata")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Config map name ", configMapName, " does not follow a recognized pattern"}));
        }
    }

    private void _validateLabels(String configMapName, Map<String, String> labels) {
        this._validateConfigMapName(configMapName);
        String metadataType = labels.get("lxc.liferay.com/metadataType");
        if (metadataType == null || !Objects.equals(metadataType, "dxp") && !Objects.equals(metadataType, "ext-init")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Config map labels must contain the key ", "\"lxc.liferay.com/metadataType\" with a value of \"dxp\" ", "or \"ext-init\""}));
        }
        String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
        if (virtualInstanceId == null) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Config map labels must contain the key ", "\"dxp.lxc.liferay.com/virtualInstanceId\" whose value is ", "the web ID of the virtual instance from which the ", "configuration originated"}));
        }
        if (configMapName.endsWith("-lxc-dxp-metadata") && !Objects.equals(virtualInstanceId.concat("-lxc-dxp-metadata"), configMapName)) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"A config map name with the suffix \"-lxc-dxp-metadata\" ", "must begin with the value of the label ", "\"dxp.lxc.liferay.com/virtualInstanceId\" followed by ", "\"-lxc-dxp-metadata\""}));
        }
        if (configMapName.endsWith("-lxc-ext-init-metadata")) {
            String serviceId = labels.get("ext.lxc.liferay.com/serviceId");
            if (serviceId == null) {
                throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"A config map with the suffix ", "\"-lxc-ext-init-metadata\" must have a label with ", "the key \"ext.lxc.liferay.com/serviceId\" whose ", "value is the target service ID"}));
            }
            if (!Objects.equals(configMapName, StringBundler.concat((String[])new String[]{serviceId, "-", virtualInstanceId, "-lxc-ext-init-metadata"}))) {
                throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"A config map name with suffix ", "\"-lxc-ext-init-metadata\" must begin with the value ", "of the label \"ext.lxc.liferay.com/serviceId\" ", "followed by a \"-\" and then the value of the label ", "\"dxp.lxc.liferay.com/virtualInstanceId\" followed ", "by \"-lxc-ext-init-metadata\""}));
            }
        }
    }
}

