/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal.util;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CompanyConfigMapUtil {
    public static void clearConfigMap(Company company, PortalK8sConfigMapModifier portalK8sConfigMapModifier) {
        portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            data.clear();
            Map labels = configMapModel.labels();
            labels.put("dxp.lxc.liferay.com/virtualInstanceId", company.getWebId());
            labels.put("lxc.liferay.com/metadataType", "dxp");
        }, CompanyConfigMapUtil.getConfigMapName(company));
    }

    public static String getConfigMapName(Company company) {
        return company.getWebId() + "-lxc-dxp-metadata";
    }

    public static void modifyConfigMap(Company company, PortalK8sConfigMapModifier portalK8sConfigMapModifier, VirtualHostLocalService virtualHostLocalService) {
        ArrayList<String> virtualHostNames = new ArrayList<String>();
        for (VirtualHost virtualHost : virtualHostLocalService.getVirtualHosts(company.getCompanyId())) {
            virtualHostNames.add(virtualHost.getHostname());
        }
        portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            data.put("com.liferay.lxc.dxp.domains", StringUtil.merge((Collection)virtualHostNames, (String)"\n"));
            data.put("com.liferay.lxc.dxp.main.domain", company.getVirtualHostname());
            data.put("com.liferay.lxc.dxp.mainDomain", company.getVirtualHostname());
            data.put("com.liferay.lxc.dxp.server.protocol", CompanyConfigMapUtil._getWebServerProtocol());
            Map labels = configMapModel.labels();
            labels.put("dxp.lxc.liferay.com/virtualInstanceId", company.getWebId());
            labels.put("lxc.liferay.com/metadataType", "dxp");
        }, CompanyConfigMapUtil.getConfigMapName(company));
    }

    private static String _getWebServerProtocol() {
        String webServerProtocol = PropsValues.WEB_SERVER_PROTOCOL;
        if (Validator.isNull((String)webServerProtocol)) {
            return "http";
        }
        return webServerProtocol;
    }
}

