/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.SimpleClientContext;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class OperationContext
extends SimpleClientContext {
    protected Object item;
    protected String resourceVersion;
    protected String plural;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected String namespace;
    protected String name;
    protected boolean cascading;
    protected boolean reloadingFromServer;
    protected boolean dryRun;
    protected boolean namespaceFromGlobalConfig;
    protected long gracePeriodSeconds = -1L;
    protected DeletionPropagation propagationPolicy;
    protected Map<String, String> labels;
    protected Map<String, String[]> labelsNot;
    protected Map<String, String[]> labelsIn;
    protected Map<String, String[]> labelsNotIn;
    protected Map<String, String> fields;
    protected Map<String, String[]> fieldsNot;
    protected String selectorAsString;
    private static final BiFunction<String, String, String> asKeyValuePair = (key, value) -> value != null ? key + "=" + value : key;
    private static final BiFunction<String, String[], String> asNotEqualToValues = (key, values2) -> Utils.isNotNull(values2) ? Arrays.stream(values2).map(v -> key + "!=" + v).collect(Collectors.joining(",")) : "!" + key;
    private static final BiFunction<String, String[], String> asInSet = OperationContext.getEntryProcessorFor("in");
    private static final BiFunction<String, String[], String> asNotInSet = OperationContext.getEntryProcessorFor("notin");

    public OperationContext() {
    }

    public OperationContext(OperationContext other) {
        this(other.httpClient, other.config, other.plural, other.namespace, other.name, other.apiGroupName, other.apiGroupVersion, other.cascading, other.item, other.labels, other.labelsNot, other.labelsIn, other.labelsNotIn, other.fields, other.fieldsNot, other.resourceVersion, other.reloadingFromServer, other.gracePeriodSeconds, other.propagationPolicy, other.namespaceFromGlobalConfig, other.dryRun, other.selectorAsString);
    }

    public OperationContext(HttpClient client, Config config, String plural, String namespace, String name, String apiGroupName, String apiGroupVersion, boolean cascading, Object item, Map<String, String> labels, Map<String, String[]> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String[]> fieldsNot, String resourceVersion, boolean reloadingFromServer, long gracePeriodSeconds, DeletionPropagation propagationPolicy, boolean namespaceFromGlobalConfig, boolean dryRun, String selectorAsString) {
        this.httpClient = client;
        this.config = config;
        this.item = item;
        this.plural = plural;
        this.setNamespace(namespace);
        this.name = name;
        this.setApiGroupName(apiGroupName);
        this.setApiGroupVersion(apiGroupVersion);
        this.cascading = cascading;
        this.setLabels(labels);
        this.setLabelsNot(labelsNot);
        this.setLabelsIn(labelsIn);
        this.setLabelsNotIn(labelsNotIn);
        this.setFields(fields);
        this.setFieldsNot(fieldsNot);
        this.resourceVersion = resourceVersion;
        this.reloadingFromServer = reloadingFromServer;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.namespaceFromGlobalConfig = namespaceFromGlobalConfig;
        this.dryRun = dryRun;
        this.selectorAsString = selectorAsString;
    }

    private void setFieldsNot(Map<String, String[]> fieldsNot) {
        this.fieldsNot = Utils.getNonNullOrElse(fieldsNot, new HashMap());
    }

    private void setFields(Map<String, String> fields) {
        this.fields = Utils.getNonNullOrElse(fields, new HashMap());
    }

    private void setLabelsNotIn(Map<String, String[]> labelsNotIn) {
        this.labelsNotIn = Utils.getNonNullOrElse(labelsNotIn, new HashMap());
    }

    private void setLabelsIn(Map<String, String[]> labelsIn) {
        this.labelsIn = Utils.getNonNullOrElse(labelsIn, new HashMap());
    }

    private void setLabelsNot(Map<String, String[]> labelsNot) {
        this.labelsNot = Utils.getNonNullOrElse(labelsNot, new HashMap());
    }

    private void setLabels(Map<String, String> labels) {
        this.labels = Utils.getNonNullOrElse(labels, new HashMap());
    }

    private void setApiGroupVersion(String apiGroupVersion) {
        this.apiGroupVersion = ApiVersionUtil.apiVersion(this.item, apiGroupVersion);
    }

    private void setApiGroupName(String apiGroupName) {
        this.apiGroupName = ApiVersionUtil.apiGroup(this.item, apiGroupName);
    }

    private void setNamespace(String namespace) {
        this.namespace = Utils.isNotNullOrEmpty(namespace) ? namespace : (this.config != null ? this.config.getNamespace() : null);
    }

    public HttpClient getClient() {
        return this.httpClient;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getApiGroupName() {
        return this.apiGroupName;
    }

    public String getApiGroupVersion() {
        return this.apiGroupVersion;
    }

    public boolean getCascading() {
        return this.cascading;
    }

    public Object getItem() {
        return this.item;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    public Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    public Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public boolean isNamespaceFromGlobalConfig() {
        return this.namespaceFromGlobalConfig;
    }

    public boolean getDryRun() {
        return this.dryRun;
    }

    public String getLabelQueryParam() {
        if (Utils.isNotNullOrEmpty(this.selectorAsString)) {
            return this.selectorAsString;
        }
        StringBuilder sb = new StringBuilder(101);
        this.appendEntriesAsParam(sb, this.getLabels(), asKeyValuePair);
        this.appendEntriesAsParam(sb, this.getLabelsNot(), asNotEqualToValues);
        this.appendEntriesAsParam(sb, this.getLabelsIn(), asInSet);
        this.appendEntriesAsParam(sb, this.getLabelsNotIn(), asNotInSet);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static BiFunction<String, String[], String> getEntryProcessorFor(String operator) {
        return (key, values2) -> key + " " + operator + " (" + String.join((CharSequence)",", values2) + ")";
    }

    private <T> void appendEntriesAsParam(StringBuilder sb, Map<String, T> entries, BiFunction<String, T, String> entryProcessor) {
        if (entries != null && !entries.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(entries.entrySet().stream().map(entry -> (String)entryProcessor.apply((String)entry.getKey(), (Object)entry.getValue())).collect(Collectors.joining(",")));
        }
    }

    public String getFieldQueryParam() {
        StringBuilder sb = new StringBuilder(101);
        if (Utils.isNotNullOrEmpty(this.getName())) {
            sb.append("metadata.name").append("=").append(this.getName());
        }
        this.appendEntriesAsParam(sb, this.getFields(), asKeyValuePair);
        this.appendEntriesAsParam(sb, this.getFieldsNot(), asNotEqualToValues);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public OperationContext copy() {
        return new OperationContext(this);
    }

    public OperationContext withHttpClient(HttpClient client) {
        if (this.httpClient == client) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.httpClient = client;
        return context;
    }

    public OperationContext withConfig(Config config) {
        if (this.config == config) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.config = config;
        return context;
    }

    public OperationContext withPlural(String plural) {
        if (Objects.equals(this.plural, plural)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.plural = plural;
        return context;
    }

    public OperationContext withNamespace(String namespace) {
        if (Objects.equals(this.namespace, namespace)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setNamespace(namespace);
        return context;
    }

    public OperationContext withName(String name) {
        if (Objects.equals(this.name, name)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.name = name;
        return context;
    }

    public OperationContext withApiGroupName(String apiGroupName) {
        if (Objects.equals(this.apiGroupName, apiGroupName)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setApiGroupName(apiGroupName);
        return context;
    }

    public OperationContext withApiGroupVersion(String apiGroupVersion) {
        if (Objects.equals(this.apiGroupVersion, apiGroupVersion)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setApiGroupVersion(apiGroupVersion);
        return context;
    }

    public OperationContext withItem(Object item) {
        if (this.item == item) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.item = item;
        return context;
    }

    public OperationContext withCascading(boolean cascading) {
        if (this.cascading == cascading) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.cascading = cascading;
        return context;
    }

    public OperationContext withLabels(Map<String, String> labels) {
        if (Objects.equals(this.labels, labels)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setLabels(labels);
        return context;
    }

    public OperationContext withLabelsIn(Map<String, String[]> labelsIn) {
        if (Objects.equals(this.labelsIn, labelsIn)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setLabelsIn(labelsIn);
        return context;
    }

    public OperationContext withLabelsNot(Map<String, String[]> labelsNot) {
        if (Objects.equals(this.labelsNot, labelsNot)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setLabelsNot(labelsNot);
        return context;
    }

    public OperationContext withLabelsNotIn(Map<String, String[]> labelsNotIn) {
        if (Objects.equals(this.labelsNotIn, labelsNotIn)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setLabelsNotIn(labelsNotIn);
        return context;
    }

    public OperationContext withFields(Map<String, String> fields) {
        if (Objects.equals(this.fields, fields)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setFields(fields);
        return context;
    }

    public OperationContext withFieldsNot(Map<String, String[]> fieldsNot) {
        if (Objects.equals(this.fieldsNot, fieldsNot)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.setFieldsNot(fieldsNot);
        return context;
    }

    public OperationContext withResourceVersion(String resourceVersion) {
        if (Objects.equals(this.resourceVersion, resourceVersion)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.resourceVersion = resourceVersion;
        return context;
    }

    public OperationContext withReloadingFromServer(boolean reloadingFromServer) {
        if (this.reloadingFromServer == reloadingFromServer) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.reloadingFromServer = reloadingFromServer;
        return context;
    }

    public OperationContext withGracePeriodSeconds(long gracePeriodSeconds) {
        if (this.gracePeriodSeconds == gracePeriodSeconds) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.gracePeriodSeconds = gracePeriodSeconds;
        return context;
    }

    public OperationContext withPropagationPolicy(DeletionPropagation propagationPolicy) {
        if (this.propagationPolicy == propagationPolicy) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.propagationPolicy = propagationPolicy;
        return context;
    }

    public OperationContext withIsNamespaceConfiguredFromGlobalConfig(boolean namespaceFromGlobalConfig) {
        if (this.namespaceFromGlobalConfig == namespaceFromGlobalConfig) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.namespaceFromGlobalConfig = namespaceFromGlobalConfig;
        return context;
    }

    public OperationContext withDryRun(boolean dryRun) {
        if (this.dryRun == dryRun) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.dryRun = dryRun;
        return context;
    }

    public OperationContext withLabelSelector(String selectorAsString) {
        if (Objects.equals(this.selectorAsString, selectorAsString)) {
            return this;
        }
        OperationContext context = new OperationContext(this);
        context.selectorAsString = selectorAsString;
        return context;
    }

    public OperationContext withOperationContext(OperationContext context) {
        return new OperationContext(Utils.getNonNullOrElse(context.getClient(), this.getClient()), Utils.getNonNullOrElse(context.getConfig(), this.getConfig()), Utils.getNonNullOrElse(context.getPlural(), this.getPlural()), Utils.getNonNullOrElse(context.getNamespace(), this.getNamespace()), Utils.getNonNullOrElse(context.getName(), this.getName()), Utils.getNonNullOrElse(context.getApiGroupName(), this.getApiGroupName()), Utils.getNonNullOrElse(context.getApiGroupVersion(), this.getApiGroupVersion()), context.getCascading() ? context.getCascading() : this.getCascading(), Utils.getNonNullOrElse(context.getItem(), this.getItem()), Utils.getNonNullOrElse(context.getLabels(), this.getLabels()), Utils.getNonNullOrElse(context.getLabelsNot(), this.getLabelsNot()), Utils.getNonNullOrElse(context.getLabelsIn(), this.getLabelsIn()), Utils.getNonNullOrElse(context.getLabelsNotIn(), this.getLabelsNotIn()), Utils.getNonNullOrElse(context.getFields(), this.getFields()), Utils.getNonNullOrElse(context.getFieldsNot(), this.getFieldsNot()), Utils.getNonNullOrElse(context.getResourceVersion(), this.getResourceVersion()), context.isReloadingFromServer() ? context.isReloadingFromServer() : this.isReloadingFromServer(), context.getGracePeriodSeconds() > 0L ? context.getGracePeriodSeconds() : this.getGracePeriodSeconds(), Utils.getNonNullOrElse(context.getPropagationPolicy(), this.getPropagationPolicy()), context.isNamespaceFromGlobalConfig() ? context.isNamespaceFromGlobalConfig() : this.isNamespaceFromGlobalConfig(), context.getDryRun() ? context.getDryRun() : this.getDryRun(), Utils.getNonNullOrElse(context.selectorAsString, this.selectorAsString));
    }
}

