/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchHTTPManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchHTTPManager.class);
    private CompletableFuture<HttpResponse<InputStream>> call;

    public WatchHTTPManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long connectTimeout) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, connectTimeout, 5);
    }

    public WatchHTTPManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long connectTimeout, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, () -> client.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).forStreaming().build());
    }

    @Override
    protected synchronized void run(URL url, Map<String, String> headers) {
        HttpRequest.Builder builder = this.client.newHttpRequestBuilder().url(url);
        headers.forEach(builder::header);
        this.call = this.client.sendAsync(builder.build(), InputStream.class);
        this.call.whenComplete((response, t) -> {
            if (!this.call.isCancelled() && t != null) {
                logger.info("Watch connection failed. reason: {}", (Object)t.getMessage());
            }
            if (response != null) {
                try (InputStream body = (InputStream)response.body();){
                    if (!response.isSuccessful()) {
                        if (this.onStatus(OperationSupport.createStatus(response.code(), response.message()))) {
                            return;
                        }
                    } else {
                        this.resetReconnectAttempts();
                        BufferedReader source2 = new BufferedReader(new InputStreamReader(body, StandardCharsets.UTF_8));
                        String message = null;
                        while ((message = source2.readLine()) != null) {
                            this.onMessage(message);
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("Watch terminated unexpectedly. reason: {}", (Object)e.getMessage());
                }
            }
            if (!this.call.isCancelled()) {
                this.scheduleReconnect();
            }
        });
    }

    @Override
    protected synchronized void closeRequest() {
        if (this.call != null) {
            this.call.cancel(true);
            this.call = null;
        }
    }
}

