/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory2) {
        this.config = config;
        this.factory = factory2;
    }

    @Override
    public boolean afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        boolean resubmit = false;
        if (response.code() == 401) {
            Config newestConfig;
            String currentContextName = null;
            String newAccessToken = null;
            if (this.config.getCurrentContext() != null) {
                currentContextName = this.config.getCurrentContext().getName();
            }
            if ((newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder()) : newestConfig.getOauthToken()) != null) {
                headerBuilder.setHeader("Authorization", "Bearer " + newAccessToken);
                this.config.setOauthToken(newAccessToken);
                resubmit = true;
            }
        }
        return resubmit;
    }
}

