/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.CacheResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.extender.internal.ServiceTrackerResourceBundleLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

public class LanguageExtension {
    private static final Log _log = LogFactoryUtil.getLog(LanguageExtension.class);
    private static final AtomicInteger _atomicInteger = new AtomicInteger();
    private final Bundle _bundle;
    private final List<BundleCapability> _bundleCapabilities;
    private final BundleContext _bundleContext;
    private final Collection<ServiceRegistration<ResourceBundleLoader>> _serviceRegistrations = new ArrayList<ServiceRegistration<ResourceBundleLoader>>();
    private final List<ServiceTrackerResourceBundleLoader> _serviceTrackerResourceBundleLoaders = new ArrayList<ServiceTrackerResourceBundleLoader>();

    public LanguageExtension(BundleContext bundleContext, Bundle bundle, List<BundleCapability> bundleCapabilities) {
        this._bundleContext = bundleContext;
        this._bundle = bundle;
        this._bundleCapabilities = bundleCapabilities;
    }

    public void destroy() {
        for (ServiceTrackerResourceBundleLoader serviceTrackerResourceBundleLoader : this._serviceTrackerResourceBundleLoaders) {
            serviceTrackerResourceBundleLoader.close();
        }
        for (ServiceRegistration serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    public void start() throws InvalidSyntaxException {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        for (BundleCapability bundleCapability : this._bundleCapabilities) {
            ResourceBundleLoader resourceBundleLoader = null;
            HashMapDictionary attributes = new HashMapDictionary(bundleCapability.getAttributes());
            Object aggregate = attributes.get("resource.bundle.aggregate");
            Object baseName = attributes.get("resource.bundle.base.name");
            Object serviceRanking = attributes.get("service.ranking");
            if (aggregate instanceof String) {
                int aggregateId = _atomicInteger.incrementAndGet();
                ServiceTrackerResourceBundleLoader serviceTrackerResourceBundleLoader = new ServiceTrackerResourceBundleLoader(this._bundleContext, (String)aggregate, aggregateId, GetterUtil.getInteger(serviceRanking));
                attributes.put("aggregateId", String.valueOf(aggregateId));
                this._serviceTrackerResourceBundleLoaders.add(serviceTrackerResourceBundleLoader);
                resourceBundleLoader = serviceTrackerResourceBundleLoader;
            } else if (baseName instanceof String) {
                Object excludePortalResources = attributes.get("exclude.portal.resources");
                if (excludePortalResources == null) {
                    excludePortalResources = "false";
                }
                resourceBundleLoader = this._processBaseName(bundleWiring.getClassLoader(), (String)baseName, GetterUtil.getBoolean(excludePortalResources));
            } else {
                attributes.put("resource.bundle.base.name", "content.Language");
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            if (Validator.isNotNull(serviceRanking)) {
                attributes.put("service.ranking", GetterUtil.getInteger(serviceRanking));
            }
            if (resourceBundleLoader != null) {
                if (Validator.isNull(attributes.get("bundle.symbolic.name"))) {
                    attributes.put("bundle.symbolic.name", this._bundle.getSymbolicName());
                }
                if (Validator.isNull(attributes.get("service.ranking"))) {
                    attributes.put("service.ranking", Integer.MIN_VALUE);
                }
                this._serviceRegistrations.add((ServiceRegistration<ResourceBundleLoader>)this._bundleContext.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, (Dictionary)attributes));
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to handle ", bundleCapability, " in ", this._bundle.getSymbolicName()}));
        }
    }

    private ResourceBundleLoader _processBaseName(ClassLoader classLoader, String baseName, boolean excludePortalResource) {
        ClassResourceBundleLoader resourceBundleLoader = new ClassResourceBundleLoader(baseName, classLoader);
        if (excludePortalResource) {
            return new CacheResourceBundleLoader((ResourceBundleLoader)resourceBundleLoader);
        }
        AggregateResourceBundleLoader aggregateResourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
        return new CacheResourceBundleLoader((ResourceBundleLoader)aggregateResourceBundleLoader);
    }
}

