/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.extender.internal;

import com.liferay.portal.kernel.language.UTF8Control;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class LanguageResourcesExtender
implements BundleTrackerCustomizer<List<ServiceRegistration<?>>> {
    private BundleContext _bundleContext;
    private BundleTracker<?> _bundleTracker;

    public List<ServiceRegistration<?>> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List bundleCapabilities = bundleWiring.getCapabilities("liferay.language.resources");
        if (ListUtil.isEmpty((List)bundleCapabilities)) {
            return null;
        }
        ArrayList serviceRegistrations = new ArrayList();
        for (BundleCapability bundleCapability : bundleCapabilities) {
            Map attributes = bundleCapability.getAttributes();
            Object baseName = attributes.get("resource.bundle.base.name");
            if (!(baseName instanceof String)) continue;
            this._registerResourceBundles(bundle, (String)baseName, GetterUtil.getInteger(attributes.get("service.ranking")), serviceRegistrations);
        }
        return serviceRegistrations;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<ServiceRegistration<?>> serviceRegistrations) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<ServiceRegistration<?>> serviceRegistrations) {
        for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private void _registerResourceBundles(Bundle bundle, final String baseName, int serviceRanking, List<ServiceRegistration<?>> serviceRegistrations) {
        Enumeration enumeration;
        final BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        int index = baseName.lastIndexOf(".");
        String path = "/";
        String name = baseName;
        if (index > 0) {
            path = baseName.substring(0, index);
            path = "/" + StringUtil.replace((String)path, (char)'.', (char)'/');
            name = baseName.substring(index + 1);
        }
        if ((enumeration = bundle.findEntries(path, name.concat("*.properties"), false)) == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String urlPath = url.getPath();
            String languageId = "";
            if (urlPath.contains("_")) {
                languageId = urlPath.substring(path.length() + name.length() + 2, urlPath.length() - ".properties".length());
            }
            final Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(ResourceBundle.class, (ServiceFactory)new ServiceFactory<ResourceBundle>(){

                public ResourceBundle getService(Bundle bundle, ServiceRegistration<ResourceBundle> serviceRegistration) {
                    return ResourceBundle.getBundle(baseName, locale, bundleWiring.getClassLoader(), (ResourceBundle.Control)UTF8Control.INSTANCE);
                }

                public void ungetService(Bundle bundle, ServiceRegistration<ResourceBundle> serviceRegistration, ResourceBundle resourceBundle) {
                }
            }, (Dictionary)HashMapDictionaryBuilder.put((Object)"service.ranking", (Object)serviceRanking).put((Object)"language.id", (Object)languageId).build());
            serviceRegistrations.add(serviceRegistration);
        }
    }
}

