/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.UTF8Control;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.CacheResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.language.extender.internal.ServiceTrackerResourceBundleLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

public class LanguageResourcesExtension {
    private static final Log _log = LogFactoryUtil.getLog(LanguageResourcesExtension.class);
    private static final AtomicInteger _atomicInteger = new AtomicInteger();
    private final Bundle _bundle;
    private final List<BundleCapability> _bundleCapabilities;
    private final BundleContext _bundleContext;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    private final List<ServiceTrackerResourceBundleLoader> _serviceTrackerResourceBundleLoaders = new ArrayList<ServiceTrackerResourceBundleLoader>();

    public LanguageResourcesExtension(BundleContext bundleContext, Bundle bundle, List<BundleCapability> bundleCapabilities) {
        this._bundleContext = bundleContext;
        this._bundle = bundle;
        this._bundleCapabilities = bundleCapabilities;
    }

    public void start() throws InvalidSyntaxException {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        for (BundleCapability bundleCapability : this._bundleCapabilities) {
            String namespace = bundleCapability.getNamespace();
            Map attributes = bundleCapability.getAttributes();
            if (GetterUtil.getBoolean(attributes.get("module.only"), (boolean)namespace.equals("liferay.resource.bundle"))) {
                this._registerResourceBundleLoader(bundleWiring, bundleCapability);
                continue;
            }
            Object baseName = attributes.get("resource.bundle.base.name");
            if (!(baseName instanceof String)) continue;
            this._registerResourceBundles(bundleWiring, (String)baseName, GetterUtil.getInteger(attributes.get("service.ranking")));
        }
    }

    public void stop() {
        for (ServiceTrackerResourceBundleLoader serviceTrackerResourceBundleLoader : this._serviceTrackerResourceBundleLoaders) {
            serviceTrackerResourceBundleLoader.close();
        }
        for (ServiceRegistration serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private ResourceBundleLoader _processBaseName(ClassLoader classLoader, String baseName, boolean excludePortalResource) {
        ClassResourceBundleLoader resourceBundleLoader = new ClassResourceBundleLoader(baseName, classLoader);
        if (excludePortalResource) {
            return new CacheResourceBundleLoader((ResourceBundleLoader)resourceBundleLoader);
        }
        AggregateResourceBundleLoader aggregateResourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER});
        return new CacheResourceBundleLoader((ResourceBundleLoader)aggregateResourceBundleLoader);
    }

    private void _registerResourceBundleLoader(BundleWiring bundleWiring, BundleCapability bundleCapability) throws InvalidSyntaxException {
        ResourceBundleLoader resourceBundleLoader = null;
        HashMapDictionary attributes = new HashMapDictionary(bundleCapability.getAttributes());
        Object aggregate = attributes.get("resource.bundle.aggregate");
        Object baseName = attributes.get("resource.bundle.base.name");
        Object serviceRanking = attributes.get("service.ranking");
        Object servletContextName = attributes.get("servlet.context.name");
        if (aggregate instanceof String) {
            int aggregateId = _atomicInteger.incrementAndGet();
            ServiceTrackerResourceBundleLoader serviceTrackerResourceBundleLoader = new ServiceTrackerResourceBundleLoader(this._bundleContext, (String)aggregate, aggregateId, GetterUtil.getInteger(serviceRanking));
            attributes.put("aggregateId", String.valueOf(aggregateId));
            this._serviceTrackerResourceBundleLoaders.add(serviceTrackerResourceBundleLoader);
            resourceBundleLoader = serviceTrackerResourceBundleLoader;
        } else if (baseName instanceof String) {
            Object excludePortalResources = attributes.get("exclude.portal.resources");
            if (excludePortalResources == null) {
                excludePortalResources = "false";
            }
            resourceBundleLoader = this._processBaseName(bundleWiring.getClassLoader(), (String)baseName, GetterUtil.getBoolean(excludePortalResources));
        } else {
            attributes.put("resource.bundle.base.name", "content.Language");
            resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        }
        if (Validator.isNotNull(serviceRanking)) {
            attributes.put("service.ranking", GetterUtil.getInteger(serviceRanking));
        }
        if (Validator.isNull(servletContextName)) {
            Dictionary headers = this._bundle.getHeaders("");
            String webContextName = (String)headers.get("Web-ContextName");
            if (Validator.isNotNull((String)webContextName)) {
                attributes.put("servlet.context.name", webContextName);
            } else {
                String webContextPath = (String)headers.get("Web-ContextPath");
                if (Validator.isNotNull((String)webContextPath)) {
                    attributes.put("servlet.context.name", webContextPath.substring(1));
                }
            }
        }
        if (resourceBundleLoader != null) {
            if (Validator.isNull(attributes.get("bundle.symbolic.name"))) {
                attributes.put("bundle.symbolic.name", this._bundle.getSymbolicName());
            }
            if (Validator.isNull(attributes.get("service.ranking"))) {
                attributes.put("service.ranking", Integer.MIN_VALUE);
            }
            this._serviceRegistrations.add(this._bundleContext.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, (Dictionary)attributes));
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to handle ", bundleCapability, " in ", this._bundle.getSymbolicName()}));
        }
    }

    private void _registerResourceBundles(final BundleWiring bundleWiring, final String baseName, int serviceRanking) {
        Enumeration enumeration;
        int index = baseName.lastIndexOf(".");
        Object path = "/";
        String name = baseName;
        if (index > 0) {
            path = baseName.substring(0, index);
            path = "/" + StringUtil.replace((String)path, (char)'.', (char)'/');
            name = baseName.substring(index + 1);
        }
        if ((enumeration = this._bundle.findEntries((String)path, name.concat("*.properties"), false)) == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String urlPath = url.getPath();
            String languageId = "";
            index = urlPath.indexOf("_", ((String)path).length());
            if (index > -1) {
                languageId = urlPath.substring(index + 1, urlPath.length() - ".properties".length());
            }
            final Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(ResourceBundle.class, (ServiceFactory)new ServiceFactory<ResourceBundle>(){

                public ResourceBundle getService(Bundle bundle, ServiceRegistration<ResourceBundle> serviceRegistration) {
                    return ResourceBundle.getBundle(baseName, locale, bundleWiring.getClassLoader(), (ResourceBundle.Control)UTF8Control.INSTANCE);
                }

                public void ungetService(Bundle bundle, ServiceRegistration<ResourceBundle> serviceRegistration, ResourceBundle resourceBundle) {
                }
            }, (Dictionary)HashMapDictionaryBuilder.put((Object)"service.ranking", (Object)serviceRanking).put((Object)"language.id", (Object)languageId).build());
            this._serviceRegistrations.add(serviceRegistration);
        }
    }
}

