/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceTrackerResourceBundleLoader
implements ResourceBundleLoader {
    private final List<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>> _serviceTrackers;

    public ServiceTrackerResourceBundleLoader(BundleContext bundleContext, String aggregate, int aggregateId, int serviceRanking) throws InvalidSyntaxException {
        List filterStrings = StringUtil.split((String)aggregate);
        this._serviceTrackers = new ArrayList<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>>(filterStrings.size());
        for (String string : filterStrings) {
            Filter filter = bundleContext.createFilter(StringBundler.concat((Object[])new Object[]{"(&(objectClass=", ResourceBundleLoader.class.getName(), ")", string, "(|(!(aggregateId=*))(!(aggregateId=", aggregateId, ")))(!(service.ranking>=", serviceRanking, ")))"}));
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, filter, null);
            this._serviceTrackers.add((ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>)serviceTracker);
        }
        for (ServiceTracker serviceTracker : this._serviceTrackers) {
            serviceTracker.open();
        }
    }

    public void close() {
        for (ServiceTracker<ResourceBundleLoader, ResourceBundleLoader> serviceTracker : this._serviceTrackers) {
            serviceTracker.close();
        }
    }

    public ResourceBundle loadResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (ServiceTracker<ResourceBundleLoader, ResourceBundleLoader> serviceTracker : this._serviceTrackers) {
            ResourceBundle resourceBundle;
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)serviceTracker.getService();
            if (resourceBundleLoader == null || (resourceBundle = resourceBundleLoader.loadResourceBundle(locale)) == null) continue;
            resourceBundles.add(resourceBundle);
        }
        if (resourceBundles.isEmpty()) {
            return null;
        }
        if (resourceBundles.size() == 1) {
            return (ResourceBundle)resourceBundles.get(0);
        }
        return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[0]));
    }
}

