/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.language.LanguageOverrideProvider;
import com.liferay.portal.language.override.internal.provider.PLOOriginalTranslationThreadLocal;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LanguageOverrideProvider.class, PLOLanguageOverrideProvider.class})
public class PLOLanguageOverrideProvider
implements LanguageOverrideProvider {
    private Map<String, HashMap<String, String>> _ploEntriesMap;
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;

    public String get(String key, Locale locale) {
        if (this._ploEntriesMap.isEmpty() || PLOOriginalTranslationThreadLocal.isUseOriginalTranslation().booleanValue()) {
            return null;
        }
        Map<String, String> overrideMap = this._getOverrideMap(CompanyThreadLocal.getCompanyId(), locale);
        return overrideMap.get(key);
    }

    public Set<String> keySet(Locale locale) {
        if (this._ploEntriesMap.isEmpty() || PLOOriginalTranslationThreadLocal.isUseOriginalTranslation().booleanValue()) {
            return Collections.emptySet();
        }
        Map<String, String> overrideMap = this._getOverrideMap(CompanyThreadLocal.getCompanyId(), locale);
        return overrideMap.keySet();
    }

    @Activate
    protected void activate() {
        this._ploEntriesMap = new ConcurrentHashMap<String, HashMap<String, String>>();
        for (PLOEntry ploEntry : this._ploEntryLocalService.getPLOEntries(-1, -1)) {
            this.add(ploEntry);
        }
    }

    protected void add(PLOEntry ploEntry) {
        this._ploEntriesMap.compute(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            if (value == null) {
                value = new HashMap<String, String>();
            }
            value.put(ploEntry.getKey(), ploEntry.getValue());
            return value;
        });
    }

    protected void remove(PLOEntry ploEntry) {
        this._ploEntriesMap.computeIfPresent(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            value.remove(ploEntry.getKey());
            if (value.isEmpty()) {
                return null;
            }
            return value;
        });
    }

    protected void update(PLOEntry ploEntry) {
        this._ploEntriesMap.computeIfPresent(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            value.put(ploEntry.getKey(), ploEntry.getValue());
            return value;
        });
    }

    private String _encodeKey(long companyId, String languageId) {
        return StringBundler.concat((Object[])new Object[]{companyId, "#", languageId});
    }

    private Map<String, String> _getOverrideMap(long companyId, Locale locale) {
        Map overrideMap = this._ploEntriesMap.get(this._encodeKey(companyId, LanguageUtil.getLanguageId((Locale)locale)));
        if (overrideMap == null) {
            return Collections.emptyMap();
        }
        return overrideMap;
    }
}

