/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.internal;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.language.override.internal.PLOOverrideResourceBundleManager;
import com.liferay.portal.language.override.model.PLOEntry;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class, IdentifiableOSGiService.class})
public class PLOEntryModelListener
extends BaseModelListener<PLOEntry>
implements IdentifiableOSGiService {
    private static final Log _log = LogFactoryUtil.getLog((String)PLOEntryModelListener.class.getName());
    private static final MethodKey _onNotifyMethodKey = new MethodKey(PLOEntryModelListener.class, "_onNotify", new Class[]{MethodType.class, String.class, PLOEntry.class});
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private PLOOverrideResourceBundleManager _ploOverrideResourceBundleManager;

    public String getOSGiServiceIdentifier() {
        return PLOEntryModelListener.class.getName();
    }

    public void onAfterCreate(PLOEntry ploEntry) {
        this._updatePLOLanguageOverrideProvider(MethodType.ADD, ploEntry);
        this._notifyCluster(MethodType.ADD, ploEntry);
    }

    public void onAfterRemove(PLOEntry ploEntry) {
        this._updatePLOLanguageOverrideProvider(MethodType.REMOVE, ploEntry);
        this._notifyCluster(MethodType.REMOVE, ploEntry);
    }

    public void onAfterUpdate(PLOEntry originalPLOEntry, PLOEntry ploEntry) {
        this._updatePLOLanguageOverrideProvider(MethodType.UPDATE, ploEntry);
        this._notifyCluster(MethodType.UPDATE, ploEntry);
    }

    private static void _onNotify(MethodType methodType, String osgiServiceIdentifier, PLOEntry ploEntry) {
        PLOEntryModelListener ploEntryModelListener = (PLOEntryModelListener)IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)osgiServiceIdentifier);
        ploEntryModelListener._updatePLOLanguageOverrideProvider(methodType, ploEntry);
    }

    private void _notifyCluster(MethodType methodType, PLOEntry ploEntry) {
        if (!this._clusterExecutor.isEnabled()) {
            return;
        }
        try {
            MethodHandler methodHandler = new MethodHandler(_onNotifyMethodKey, new Object[]{methodType, this.getOSGiServiceIdentifier(), ploEntry});
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
            clusterRequest.setFireAndForget(true);
            this._clusterExecutor.execute(clusterRequest);
        }
        catch (Throwable throwable) {
            _log.error(throwable);
        }
    }

    private void _updatePLOLanguageOverrideProvider(MethodType methodType, PLOEntry ploEntry) {
        if (methodType == MethodType.ADD) {
            this._ploOverrideResourceBundleManager.add(ploEntry);
        } else if (methodType == MethodType.REMOVE) {
            this._ploOverrideResourceBundleManager.remove(ploEntry);
        } else if (methodType == MethodType.UPDATE) {
            this._ploOverrideResourceBundleManager.update(ploEntry);
        }
    }

    private static enum MethodType {
        ADD,
        REMOVE,
        UPDATE;

    }
}

