/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.internal;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.language.override.internal.provider.PLOOriginalTranslationThreadLocal;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PLOOverrideResourceBundleManager.class})
public class PLOOverrideResourceBundleManager {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Language _language;
    private final DCLSingleton<Map<String, OverrideResourceBundle>> _overrideResourceBundlesDCLSingleton = new DCLSingleton();
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;
    private final Supplier<Map<String, OverrideResourceBundle>> _supplier = this::_createOverrideResourceBundles;

    public ResourceBundle getOverrideResourceBundle(Locale locale) {
        Map overrideResourceBundles = (Map)this._overrideResourceBundlesDCLSingleton.getSingleton(this._supplier);
        if (overrideResourceBundles.isEmpty() || PLOOriginalTranslationThreadLocal.isUseOriginalTranslation().booleanValue()) {
            return null;
        }
        return (ResourceBundle)overrideResourceBundles.get(this._encodeKey(CompanyThreadLocal.getCompanyId(), this._language.getLanguageId(locale)));
    }

    protected void add(PLOEntry ploEntry) {
        this._add((Map)this._overrideResourceBundlesDCLSingleton.getSingleton(this._supplier), ploEntry);
    }

    protected void remove(PLOEntry ploEntry) {
        Map overrideResourceBundles = (Map)this._overrideResourceBundlesDCLSingleton.getSingleton(this._supplier);
        overrideResourceBundles.computeIfPresent(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            value.remove(ploEntry.getKey());
            if (value.isEmpty()) {
                return null;
            }
            return value;
        });
    }

    protected void update(PLOEntry ploEntry) {
        Map overrideResourceBundles = (Map)this._overrideResourceBundlesDCLSingleton.getSingleton(this._supplier);
        overrideResourceBundles.computeIfPresent(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            value.put(ploEntry.getKey(), ploEntry.getValue());
            return value;
        });
    }

    private void _add(Map<String, OverrideResourceBundle> overrideResourceBundles, PLOEntry ploEntry) {
        overrideResourceBundles.compute(this._encodeKey(ploEntry.getCompanyId(), ploEntry.getLanguageId()), (key, value) -> {
            if (value == null) {
                value = new OverrideResourceBundle(new HashMap());
            }
            value.put(ploEntry.getKey(), ploEntry.getValue());
            return value;
        });
    }

    private Map<String, OverrideResourceBundle> _createOverrideResourceBundles() {
        ConcurrentHashMap<String, OverrideResourceBundle> overrideResourceBundles = new ConcurrentHashMap<String, OverrideResourceBundle>();
        this._companyLocalService.forEachCompanyId(companyId -> {
            for (PLOEntry ploEntry : this._ploEntryLocalService.getPLOEntries(companyId.longValue())) {
                this._add(overrideResourceBundles, ploEntry);
            }
        });
        return overrideResourceBundles;
    }

    private String _encodeKey(long companyId, String languageId) {
        return StringBundler.concat((Object[])new Object[]{companyId, "#", languageId});
    }

    private static class OverrideResourceBundle
    extends ResourceBundle {
        private final Map<String, String> _overrideMap;

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this._overrideMap.keySet());
        }

        public boolean isEmpty() {
            return this._overrideMap.isEmpty();
        }

        public void put(String key, String value) {
            this._overrideMap.put(key, value);
        }

        public void remove(String key) {
            this._overrideMap.remove(key);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this._overrideMap.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            return this._overrideMap.keySet();
        }

        private OverrideResourceBundle(Map<String, String> overrideMap) {
            this._overrideMap = overrideMap;
        }
    }
}

