/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.override.exception.PLOEntryKeyException;
import com.liferay.portal.language.override.exception.PLOEntryValueException;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.base.PLOEntryLocalServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.language.override.model.PLOEntry"}, service={AopService.class})
public class PLOEntryLocalServiceImpl
extends PLOEntryLocalServiceBaseImpl {
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;

    public PLOEntry addOrUpdatePLOEntry(long companyId, long userId, String key, String languageId, String value) throws PortalException {
        this._validate(key, value);
        PLOEntry ploEntry = this.fetchPLOEntry(companyId, key, languageId);
        if (ploEntry == null) {
            ploEntry = this.createPLOEntry(this.counterLocalService.increment());
            ploEntry.setCompanyId(companyId);
            User user = this._userLocalService.getUser(userId);
            ploEntry.setUserId(user.getUserId());
            ploEntry.setKey(key);
            ploEntry.setLanguageId(languageId);
            ploEntry.setValue(value);
            return this.addPLOEntry(ploEntry);
        }
        if (Objects.equals(ploEntry.getValue(), value)) {
            return ploEntry;
        }
        ploEntry.setValue(value);
        return this.updatePLOEntry(ploEntry);
    }

    public void deletePLOEntries(long companyId, String key) {
        this.ploEntryPersistence.removeByC_K(companyId, key);
    }

    public PLOEntry deletePLOEntry(long companyId, String key, String languageId) {
        PLOEntry ploEntry = this.fetchPLOEntry(companyId, key, languageId);
        if (ploEntry == null) {
            return null;
        }
        return this.deletePLOEntry(ploEntry);
    }

    public PLOEntry fetchPLOEntry(long companyId, String key, String languageId) {
        return this.ploEntryPersistence.fetchByC_K_L(companyId, key, languageId);
    }

    public List<PLOEntry> getPLOEntries(long companyId) {
        return this.ploEntryPersistence.findByCompanyId(companyId);
    }

    public List<PLOEntry> getPLOEntries(long companyId, String languageId) {
        return this.ploEntryPersistence.findByC_L(companyId, languageId);
    }

    public int getPLOEntriesCount(long companyId) {
        return this.ploEntryPersistence.countByCompanyId(companyId);
    }

    public void setPLOEntries(long companyId, long userId, String key, Map<Locale, String> localizationMap) throws PortalException {
        for (Map.Entry<Locale, String> entry : localizationMap.entrySet()) {
            String languageId = this._language.getLanguageId(entry.getKey());
            String value = StringUtil.trim((String)entry.getValue());
            if (value == null || value.equals("")) {
                this.deletePLOEntry(companyId, key, languageId);
                continue;
            }
            this.addOrUpdatePLOEntry(companyId, userId, key, languageId, value);
        }
    }

    private void _validate(String key, String value) throws PortalException {
        if (Validator.isBlank((String)key)) {
            throw new PLOEntryKeyException.MustNotBeNull();
        }
        int keyMaxLength = ModelHintsUtil.getMaxLength((String)PLOEntry.class.getName(), (String)"key");
        if (key.length() > keyMaxLength) {
            throw new PLOEntryKeyException.MustBeShorter((long)keyMaxLength);
        }
        if (Validator.isBlank((String)value)) {
            throw new PLOEntryValueException.MustNotBeNull();
        }
    }
}

