/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.internal;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.language.override.internal.PLOOverrideResourceBundleManager;
import com.liferay.portal.language.override.model.PLOEntry;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class PLOEntryModelListener
extends BaseModelListener<PLOEntry> {
    private static final MethodHandler _clearCacheMethodHandle = new MethodHandler(new MethodKey(PLOOverrideResourceBundleManager.class, "clearCache", new Class[0]), new Object[0]);
    @Reference
    private ClusterExecutor _clusterExecutor;

    public static void clearCache(ClusterExecutor clusterExecutor) {
        PLOOverrideResourceBundleManager.clearCache();
        if (!clusterExecutor.isEnabled() || !ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)_clearCacheMethodHandle, (boolean)true);
        clusterRequest.setFireAndForget(true);
        TransactionCommitCallbackUtil.registerCallback(() -> clusterExecutor.execute(clusterRequest));
    }

    public void onAfterCreate(PLOEntry ploEntry) {
        PLOEntryModelListener.clearCache(this._clusterExecutor);
    }

    public void onAfterRemove(PLOEntry ploEntry) {
        PLOEntryModelListener.clearCache(this._clusterExecutor);
    }

    public void onAfterUpdate(PLOEntry originalPLOEntry, PLOEntry ploEntry) {
        PLOEntryModelListener.clearCache(this._clusterExecutor);
    }
}

