/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.language.override.service.persistence.PLOEntryPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class PLOEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
PLOEntryLocalService {
    protected PLOEntryLocalService ploEntryLocalService;
    @Reference
    protected PLOEntryPersistence ploEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PLOEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public PLOEntry addPLOEntry(PLOEntry ploEntry) {
        ploEntry.setNew(true);
        return (PLOEntry)this.ploEntryPersistence.update((BaseModel)ploEntry);
    }

    @Transactional(enabled=false)
    public PLOEntry createPLOEntry(long ploEntryId) {
        return this.ploEntryPersistence.create(ploEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public PLOEntry deletePLOEntry(long ploEntryId) throws PortalException {
        return this.ploEntryPersistence.remove(ploEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public PLOEntry deletePLOEntry(PLOEntry ploEntry) {
        return (PLOEntry)this.ploEntryPersistence.remove((BaseModel)ploEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.ploEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(PLOEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.ploEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.ploEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.ploEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.ploEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.ploEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public PLOEntry fetchPLOEntry(long ploEntryId) {
        return this.ploEntryPersistence.fetchByPrimaryKey(ploEntryId);
    }

    public PLOEntry getPLOEntry(long ploEntryId) throws PortalException {
        return this.ploEntryPersistence.findByPrimaryKey(ploEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ploEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(PLOEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ploEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ploEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(PLOEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("ploEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ploEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(PLOEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ploEntryId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.ploEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement PLOEntryLocalServiceImpl#deletePLOEntry(PLOEntry) to avoid orphaned data");
        }
        return this.ploEntryLocalService.deletePLOEntry((PLOEntry)persistedModel);
    }

    public BasePersistence<PLOEntry> getBasePersistence() {
        return this.ploEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.ploEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<PLOEntry> getPLOEntries(int start, int end) {
        return this.ploEntryPersistence.findAll(start, end);
    }

    public int getPLOEntriesCount() {
        return this.ploEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public PLOEntry updatePLOEntry(PLOEntry ploEntry) {
        return (PLOEntry)this.ploEntryPersistence.update((BaseModel)ploEntry);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{PLOEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.ploEntryLocalService = (PLOEntryLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return PLOEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return PLOEntry.class;
    }

    protected String getModelClassName() {
        return PLOEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.ploEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

