/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.service.impl;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.override.exception.PLOEntryImportException;
import com.liferay.portal.language.override.exception.PLOEntryKeyException;
import com.liferay.portal.language.override.exception.PLOEntryLanguageIdException;
import com.liferay.portal.language.override.exception.PLOEntryValueException;
import com.liferay.portal.language.override.internal.PLOEntryModelListener;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.base.PLOEntryLocalServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.language.override.model.PLOEntry"}, service={AopService.class})
public class PLOEntryLocalServiceImpl
extends PLOEntryLocalServiceBaseImpl {
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private Language _language;

    public PLOEntry addOrUpdatePLOEntry(long companyId, long userId, String key, String languageId, String value) throws PortalException {
        languageId = this._normalizeLanguageId(languageId);
        this._validate(key, languageId, value);
        return this._addOrUpdatePLOEntry(companyId, userId, key, languageId, value);
    }

    public void deletePLOEntries(long companyId, String key) {
        this.ploEntryPersistence.removeByC_K(companyId, key);
    }

    public PLOEntry deletePLOEntry(long companyId, String key, String languageId) {
        PLOEntry ploEntry = this.fetchPLOEntry(companyId, key, languageId);
        if (ploEntry == null) {
            return null;
        }
        return this.deletePLOEntry(ploEntry);
    }

    public PLOEntry fetchPLOEntry(long companyId, String key, String languageId) {
        return this.ploEntryPersistence.fetchByC_K_L(companyId, key, languageId);
    }

    public List<PLOEntry> getPLOEntries(long companyId) {
        return this.ploEntryPersistence.findByCompanyId(companyId);
    }

    public List<PLOEntry> getPLOEntries(long companyId, String languageId) {
        return this.ploEntryPersistence.findByC_L(companyId, languageId);
    }

    public int getPLOEntriesCount(long companyId) {
        return this.ploEntryPersistence.countByCompanyId(companyId);
    }

    public void importPLOEntries(long companyId, long userId, String languageId, Properties properties) throws PortalException {
        languageId = this._normalizeLanguageId(languageId);
        PLOEntryImportException.InvalidTranslations invalidTranslations = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            try {
                this._validate((String)entry.getKey(), languageId, (String)entry.getValue());
            }
            catch (Exception exception) {
                if (invalidTranslations == null) {
                    invalidTranslations = new PLOEntryImportException.InvalidTranslations();
                }
                invalidTranslations.addSuppressed((Throwable)exception);
            }
        }
        if (invalidTranslations != null) {
            throw invalidTranslations;
        }
        try (SafeCloseable safeCloseable = ClusterInvokeThreadLocal.setEnabledWithSafeCloseable((boolean)false);){
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._addOrUpdatePLOEntry(companyId, userId, (String)entry.getKey(), languageId, (String)entry.getValue());
            }
        }
        PLOEntryModelListener.clearCache(this._clusterExecutor);
    }

    public void setPLOEntries(long companyId, long userId, String key, Map<Locale, String> localizationMap) throws PortalException {
        for (Map.Entry<Locale, String> entry : localizationMap.entrySet()) {
            String languageId = this._language.getLanguageId(entry.getKey());
            String value = StringUtil.trim((String)entry.getValue());
            if (value == null || value.equals("")) {
                this.deletePLOEntry(companyId, key, languageId);
                continue;
            }
            this.addOrUpdatePLOEntry(companyId, userId, key, languageId, value);
        }
    }

    private PLOEntry _addOrUpdatePLOEntry(long companyId, long userId, String key, String languageId, String value) {
        PLOEntry ploEntry = this.fetchPLOEntry(companyId, key, languageId);
        if (ploEntry == null) {
            ploEntry = this.createPLOEntry(this.counterLocalService.increment());
            ploEntry.setCompanyId(companyId);
            ploEntry.setUserId(userId);
            ploEntry.setKey(key);
            ploEntry.setLanguageId(languageId);
            ploEntry.setValue(value);
            return this.addPLOEntry(ploEntry);
        }
        if (Objects.equals(ploEntry.getValue(), value)) {
            return ploEntry;
        }
        ploEntry.setValue(value);
        return this.updatePLOEntry(ploEntry);
    }

    private String _normalizeLanguageId(String languageId) {
        String[] parts = ((String)(languageId = StringUtil.replace((String)languageId, (char)'-', (char)'_'))).split("_");
        if (parts.length < 2) {
            Locale locale = this._language.getLocale((String)languageId);
            if (locale == null) {
                return languageId;
            }
            return locale.toString();
        }
        languageId = StringUtil.lowerCase((String)parts[0]) + "_" + StringUtil.upperCase((String)parts[1]);
        if (parts.length == 3) {
            return (String)languageId + "_" + parts[2];
        }
        return languageId;
    }

    private void _validate(String key, String languageId, String value) throws PortalException {
        if (Validator.isBlank((String)key)) {
            throw new PLOEntryKeyException.MustNotBeNull();
        }
        int keyMaxLength = ModelHintsUtil.getMaxLength((String)PLOEntry.class.getName(), (String)"key");
        if (key.length() > keyMaxLength) {
            throw new PLOEntryKeyException.MustBeShorter((long)keyMaxLength);
        }
        Set availableLocales = this._language.getAvailableLocales();
        Object[] availableLanguageIds = (String[])TransformUtil.unsafeTransform((Object[])availableLocales.toArray(), String::valueOf, String.class);
        if (!ArrayUtil.contains((Object[])availableLanguageIds, (Object)languageId)) {
            throw new PLOEntryLanguageIdException.MustBeAvailable((String[])availableLanguageIds, languageId);
        }
        if (Validator.isBlank((String)value)) {
            throw new PLOEntryValueException.MustNotBeNull();
        }
    }
}

