/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.service.base.PLOEntryServiceBaseImpl;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=portallanguageoverride", "json.web.service.context.path=PLOEntry"}, service={AopService.class})
public class PLOEntryServiceImpl
extends PLOEntryServiceBaseImpl {
    public PLOEntry addOrUpdatePLOEntry(String key, String languageId, String value) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"MANAGE_LANGUAGE_OVERRIDES");
        return this.ploEntryLocalService.addOrUpdatePLOEntry(permissionChecker.getCompanyId(), permissionChecker.getUserId(), key, languageId, value);
    }

    public void deletePLOEntries(String key) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"MANAGE_LANGUAGE_OVERRIDES");
        this.ploEntryLocalService.deletePLOEntries(permissionChecker.getCompanyId(), key);
    }

    public PLOEntry deletePLOEntry(String key, String languageId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"MANAGE_LANGUAGE_OVERRIDES");
        return this.ploEntryLocalService.deletePLOEntry(permissionChecker.getCompanyId(), key, languageId);
    }

    public List<PLOEntry> getPLOEntries(long companyId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_LANGUAGE_OVERRIDES");
        return this.ploEntryLocalService.getPLOEntries(companyId);
    }

    public int getPLOEntriesCount(long companyId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_LANGUAGE_OVERRIDES");
        return this.ploEntryLocalService.getPLOEntriesCount(companyId);
    }

    public void importPLOEntries(String languageId, Properties properties) throws IOException, PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"MANAGE_LANGUAGE_OVERRIDES");
        this.ploEntryLocalService.importPLOEntries(permissionChecker.getCompanyId(), permissionChecker.getUserId(), languageId, properties);
    }

    public void setPLOEntries(String key, Map<Locale, String> localizationMap) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"MANAGE_LANGUAGE_OVERRIDES");
        this.ploEntryLocalService.setPLOEntries(permissionChecker.getCompanyId(), permissionChecker.getUserId(), key, localizationMap);
    }
}

