/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.override.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.language.override.exception.NoSuchPLOEntryException;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.model.PLOEntryTable;
import com.liferay.portal.language.override.model.impl.PLOEntryImpl;
import com.liferay.portal.language.override.model.impl.PLOEntryModelImpl;
import com.liferay.portal.language.override.service.persistence.PLOEntryPersistence;
import com.liferay.portal.language.override.service.persistence.PLOEntryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PLOEntryPersistence.class})
public class PLOEntryPersistenceImpl
extends BasePersistenceImpl<PLOEntry>
implements PLOEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = PLOEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "ploEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_K;
    private FinderPath _finderPathWithoutPaginationFindByC_K;
    private FinderPath _finderPathCountByC_K;
    private static final String _FINDER_COLUMN_C_K_COMPANYID_2 = "ploEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_K_KEY_2 = "ploEntry.key = ?";
    private static final String _FINDER_COLUMN_C_K_KEY_3 = "(ploEntry.key IS NULL OR ploEntry.key = '')";
    private FinderPath _finderPathWithPaginationFindByC_L;
    private FinderPath _finderPathWithoutPaginationFindByC_L;
    private FinderPath _finderPathCountByC_L;
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "ploEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LANGUAGEID_2 = "ploEntry.languageId = ?";
    private static final String _FINDER_COLUMN_C_L_LANGUAGEID_3 = "(ploEntry.languageId IS NULL OR ploEntry.languageId = '')";
    private FinderPath _finderPathFetchByC_K_L;
    private static final String _FINDER_COLUMN_C_K_L_COMPANYID_2 = "ploEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_K_L_KEY_2 = "ploEntry.key = ? AND ";
    private static final String _FINDER_COLUMN_C_K_L_KEY_3 = "(ploEntry.key IS NULL OR ploEntry.key = '') AND ";
    private static final String _FINDER_COLUMN_C_K_L_LANGUAGEID_2 = "ploEntry.languageId = ?";
    private static final String _FINDER_COLUMN_C_K_L_LANGUAGEID_3 = "(ploEntry.languageId IS NULL OR ploEntry.languageId = '')";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_PLOENTRY = "SELECT ploEntry FROM PLOEntry ploEntry";
    private static final String _SQL_SELECT_PLOENTRY_WHERE = "SELECT ploEntry FROM PLOEntry ploEntry WHERE ";
    private static final String _SQL_COUNT_PLOENTRY = "SELECT COUNT(ploEntry) FROM PLOEntry ploEntry";
    private static final String _SQL_COUNT_PLOENTRY_WHERE = "SELECT COUNT(ploEntry) FROM PLOEntry ploEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ploEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No PLOEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No PLOEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(PLOEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"key"});

    public List<PLOEntry> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<PLOEntry> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<PLOEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<PLOEntry> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<PLOEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<PLOEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (PLOEntry ploEntry : list) {
                if (companyId == ploEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_PLOENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ploEntry.key ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public PLOEntry findByCompanyId_First(long companyId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByCompanyId_First(long companyId, OrderByComparator<PLOEntry> orderByComparator) {
        List<PLOEntry> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry findByCompanyId_Last(long companyId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByCompanyId_Last(long companyId, OrderByComparator<PLOEntry> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<PLOEntry> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry[] findByCompanyId_PrevAndNext(long ploEntryId, long companyId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.findByPrimaryKey(ploEntryId);
        Session session = null;
        try {
            session = this.openSession();
            PLOEntry[] array = new PLOEntryImpl[]{this.getByCompanyId_PrevAndNext(session, ploEntry, companyId, orderByComparator, true), ploEntry, this.getByCompanyId_PrevAndNext(session, ploEntry, companyId, orderByComparator, false)};
            PLOEntry[] pLOEntryArray = array;
            return pLOEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PLOEntry getByCompanyId_PrevAndNext(Session session, PLOEntry ploEntry, long companyId, OrderByComparator<PLOEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_PLOENTRY_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ploEntry.key ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ploEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (PLOEntry)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (PLOEntry ploEntry : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)ploEntry);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_PLOENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<PLOEntry> findByC_K(long companyId, String key) {
        return this.findByC_K(companyId, key, -1, -1, null);
    }

    public List<PLOEntry> findByC_K(long companyId, String key, int start, int end) {
        return this.findByC_K(companyId, key, start, end, null);
    }

    public List<PLOEntry> findByC_K(long companyId, String key, int start, int end, OrderByComparator<PLOEntry> orderByComparator) {
        return this.findByC_K(companyId, key, start, end, orderByComparator, true);
    }

    public List<PLOEntry> findByC_K(long companyId, String key, int start, int end, OrderByComparator<PLOEntry> orderByComparator, boolean useFinderCache) {
        key = Objects.toString(key, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_K;
                finderArgs = new Object[]{companyId, key};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_K;
            finderArgs = new Object[]{companyId, key, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (PLOEntry ploEntry : list) {
                if (companyId == ploEntry.getCompanyId() && key.equals(ploEntry.getKey())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_PLOENTRY_WHERE);
            sb.append("ploEntry.companyId = ? AND ");
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_C_K_KEY_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ploEntry.key ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindKey) {
                    queryPos.add(key);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public PLOEntry findByC_K_First(long companyId, String key, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByC_K_First(companyId, key, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", key=");
        sb.append(key);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByC_K_First(long companyId, String key, OrderByComparator<PLOEntry> orderByComparator) {
        List<PLOEntry> list = this.findByC_K(companyId, key, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry findByC_K_Last(long companyId, String key, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByC_K_Last(companyId, key, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", key=");
        sb.append(key);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByC_K_Last(long companyId, String key, OrderByComparator<PLOEntry> orderByComparator) {
        int count = this.countByC_K(companyId, key);
        if (count == 0) {
            return null;
        }
        List<PLOEntry> list = this.findByC_K(companyId, key, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry[] findByC_K_PrevAndNext(long ploEntryId, long companyId, String key, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        key = Objects.toString(key, "");
        PLOEntry ploEntry = this.findByPrimaryKey(ploEntryId);
        Session session = null;
        try {
            session = this.openSession();
            PLOEntry[] array = new PLOEntryImpl[]{this.getByC_K_PrevAndNext(session, ploEntry, companyId, key, orderByComparator, true), ploEntry, this.getByC_K_PrevAndNext(session, ploEntry, companyId, key, orderByComparator, false)};
            PLOEntry[] pLOEntryArray = array;
            return pLOEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PLOEntry getByC_K_PrevAndNext(Session session, PLOEntry ploEntry, long companyId, String key, OrderByComparator<PLOEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_PLOENTRY_WHERE);
        sb.append("ploEntry.companyId = ? AND ");
        boolean bindKey = false;
        if (key.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_K_KEY_3);
        } else {
            bindKey = true;
            sb.append(_FINDER_COLUMN_C_K_KEY_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ploEntry.key ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindKey) {
            queryPos.add(key);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ploEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (PLOEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_K(long companyId, String key) {
        for (PLOEntry ploEntry : this.findByC_K(companyId, key, -1, -1, null)) {
            this.remove((BaseModel)ploEntry);
        }
    }

    public int countByC_K(long companyId, String key) {
        key = Objects.toString(key, "");
        FinderPath finderPath = this._finderPathCountByC_K;
        Object[] finderArgs = new Object[]{companyId, key};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_PLOENTRY_WHERE);
            sb.append("ploEntry.companyId = ? AND ");
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_C_K_KEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindKey) {
                    queryPos.add(key);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<PLOEntry> findByC_L(long companyId, String languageId) {
        return this.findByC_L(companyId, languageId, -1, -1, null);
    }

    public List<PLOEntry> findByC_L(long companyId, String languageId, int start, int end) {
        return this.findByC_L(companyId, languageId, start, end, null);
    }

    public List<PLOEntry> findByC_L(long companyId, String languageId, int start, int end, OrderByComparator<PLOEntry> orderByComparator) {
        return this.findByC_L(companyId, languageId, start, end, orderByComparator, true);
    }

    public List<PLOEntry> findByC_L(long companyId, String languageId, int start, int end, OrderByComparator<PLOEntry> orderByComparator, boolean useFinderCache) {
        languageId = Objects.toString(languageId, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_L;
                finderArgs = new Object[]{companyId, languageId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_L;
            finderArgs = new Object[]{companyId, languageId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (PLOEntry ploEntry : list) {
                if (companyId == ploEntry.getCompanyId() && languageId.equals(ploEntry.getLanguageId())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_PLOENTRY_WHERE);
            sb.append("ploEntry.companyId = ? AND ");
            boolean bindLanguageId = false;
            if (languageId.isEmpty()) {
                sb.append("(ploEntry.languageId IS NULL OR ploEntry.languageId = '')");
            } else {
                bindLanguageId = true;
                sb.append("ploEntry.languageId = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ploEntry.key ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindLanguageId) {
                    queryPos.add(languageId);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public PLOEntry findByC_L_First(long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByC_L_First(companyId, languageId, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", languageId=");
        sb.append(languageId);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByC_L_First(long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator) {
        List<PLOEntry> list = this.findByC_L(companyId, languageId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry findByC_L_Last(long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByC_L_Last(companyId, languageId, orderByComparator);
        if (ploEntry != null) {
            return ploEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", languageId=");
        sb.append(languageId);
        sb.append("}");
        throw new NoSuchPLOEntryException(sb.toString());
    }

    public PLOEntry fetchByC_L_Last(long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator) {
        int count = this.countByC_L(companyId, languageId);
        if (count == 0) {
            return null;
        }
        List<PLOEntry> list = this.findByC_L(companyId, languageId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PLOEntry[] findByC_L_PrevAndNext(long ploEntryId, long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator) throws NoSuchPLOEntryException {
        languageId = Objects.toString(languageId, "");
        PLOEntry ploEntry = this.findByPrimaryKey(ploEntryId);
        Session session = null;
        try {
            session = this.openSession();
            PLOEntry[] array = new PLOEntryImpl[]{this.getByC_L_PrevAndNext(session, ploEntry, companyId, languageId, orderByComparator, true), ploEntry, this.getByC_L_PrevAndNext(session, ploEntry, companyId, languageId, orderByComparator, false)};
            PLOEntry[] pLOEntryArray = array;
            return pLOEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PLOEntry getByC_L_PrevAndNext(Session session, PLOEntry ploEntry, long companyId, String languageId, OrderByComparator<PLOEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_PLOENTRY_WHERE);
        sb.append("ploEntry.companyId = ? AND ");
        boolean bindLanguageId = false;
        if (languageId.isEmpty()) {
            sb.append("(ploEntry.languageId IS NULL OR ploEntry.languageId = '')");
        } else {
            bindLanguageId = true;
            sb.append("ploEntry.languageId = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ploEntry.key ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindLanguageId) {
            queryPos.add(languageId);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ploEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (PLOEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_L(long companyId, String languageId) {
        for (PLOEntry ploEntry : this.findByC_L(companyId, languageId, -1, -1, null)) {
            this.remove((BaseModel)ploEntry);
        }
    }

    public int countByC_L(long companyId, String languageId) {
        languageId = Objects.toString(languageId, "");
        FinderPath finderPath = this._finderPathCountByC_L;
        Object[] finderArgs = new Object[]{companyId, languageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_PLOENTRY_WHERE);
            sb.append("ploEntry.companyId = ? AND ");
            boolean bindLanguageId = false;
            if (languageId.isEmpty()) {
                sb.append("(ploEntry.languageId IS NULL OR ploEntry.languageId = '')");
            } else {
                bindLanguageId = true;
                sb.append("ploEntry.languageId = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindLanguageId) {
                    queryPos.add(languageId);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public PLOEntry findByC_K_L(long companyId, String key, String languageId) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.fetchByC_K_L(companyId, key, languageId);
        if (ploEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", key=");
            sb.append(key);
            sb.append(", languageId=");
            sb.append(languageId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchPLOEntryException(sb.toString());
        }
        return ploEntry;
    }

    public PLOEntry fetchByC_K_L(long companyId, String key, String languageId) {
        return this.fetchByC_K_L(companyId, key, languageId, true);
    }

    public PLOEntry fetchByC_K_L(long companyId, String key, String languageId, boolean useFinderCache) {
        PLOEntry ploEntry;
        key = Objects.toString(key, "");
        languageId = Objects.toString(languageId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, key, languageId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_K_L, finderArgs, (BasePersistence)this);
        }
        if (!(!(result instanceof PLOEntry) || companyId == (ploEntry = (PLOEntry)result).getCompanyId() && Objects.equals(key, ploEntry.getKey()) && Objects.equals(languageId, ploEntry.getLanguageId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_PLOENTRY_WHERE);
            sb.append("ploEntry.companyId = ? AND ");
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_L_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_C_K_L_KEY_2);
            }
            boolean bindLanguageId = false;
            if (languageId.isEmpty()) {
                sb.append("(ploEntry.languageId IS NULL OR ploEntry.languageId = '')");
            } else {
                bindLanguageId = true;
                sb.append("ploEntry.languageId = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindKey) {
                    queryPos.add(key);
                }
                if (bindLanguageId) {
                    queryPos.add(languageId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_K_L, finderArgs, (Object)list);
                    }
                } else {
                    PLOEntry ploEntry2 = (PLOEntry)list.get(0);
                    result = ploEntry2;
                    this.cacheResult(ploEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (PLOEntry)result;
    }

    public PLOEntry removeByC_K_L(long companyId, String key, String languageId) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = this.findByC_K_L(companyId, key, languageId);
        return (PLOEntry)this.remove((BaseModel)ploEntry);
    }

    public int countByC_K_L(long companyId, String key, String languageId) {
        PLOEntry ploEntry = this.fetchByC_K_L(companyId, key, languageId);
        if (ploEntry == null) {
            return 0;
        }
        return 1;
    }

    public PLOEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("key", "key_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(PLOEntry.class);
        this.setModelImplClass(PLOEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)PLOEntryTable.INSTANCE);
    }

    public void cacheResult(PLOEntry ploEntry) {
        this.entityCache.putResult(PLOEntryImpl.class, (Serializable)Long.valueOf(ploEntry.getPrimaryKey()), (Serializable)ploEntry);
        this.finderCache.putResult(this._finderPathFetchByC_K_L, new Object[]{ploEntry.getCompanyId(), ploEntry.getKey(), ploEntry.getLanguageId()}, (Object)ploEntry);
    }

    public void cacheResult(List<PLOEntry> ploEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && ploEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (PLOEntry ploEntry : ploEntries) {
            if (this.entityCache.getResult(PLOEntryImpl.class, (Serializable)Long.valueOf(ploEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(ploEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(PLOEntryImpl.class);
        this.finderCache.clearCache(PLOEntryImpl.class);
    }

    public void clearCache(PLOEntry ploEntry) {
        this.entityCache.removeResult(PLOEntryImpl.class, (BaseModel)ploEntry);
    }

    public void clearCache(List<PLOEntry> ploEntries) {
        for (PLOEntry ploEntry : ploEntries) {
            this.entityCache.removeResult(PLOEntryImpl.class, (BaseModel)ploEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(PLOEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(PLOEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(PLOEntryModelImpl ploEntryModelImpl) {
        Object[] args = new Object[]{ploEntryModelImpl.getCompanyId(), ploEntryModelImpl.getKey(), ploEntryModelImpl.getLanguageId()};
        this.finderCache.putResult(this._finderPathFetchByC_K_L, args, (Object)ploEntryModelImpl);
    }

    public PLOEntry create(long ploEntryId) {
        PLOEntryImpl ploEntry = new PLOEntryImpl();
        ploEntry.setNew(true);
        ploEntry.setPrimaryKey(ploEntryId);
        ploEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ploEntry;
    }

    public PLOEntry remove(long ploEntryId) throws NoSuchPLOEntryException {
        return this.remove(Long.valueOf(ploEntryId));
    }

    public PLOEntry remove(Serializable primaryKey) throws NoSuchPLOEntryException {
        Session session = null;
        try {
            session = this.openSession();
            PLOEntry ploEntry = (PLOEntry)session.get(PLOEntryImpl.class, primaryKey);
            if (ploEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchPLOEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            PLOEntry pLOEntry = (PLOEntry)this.remove((BaseModel)ploEntry);
            return pLOEntry;
        }
        catch (NoSuchPLOEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PLOEntry removeImpl(PLOEntry ploEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ploEntry)) {
                ploEntry = (PLOEntry)session.get(PLOEntryImpl.class, ploEntry.getPrimaryKeyObj());
            }
            if (ploEntry != null) {
                session.delete((Object)ploEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ploEntry != null) {
            this.clearCache(ploEntry);
        }
        return ploEntry;
    }

    public PLOEntry updateImpl(PLOEntry ploEntry) {
        long userId;
        boolean isNew = ploEntry.isNew();
        if (!(ploEntry instanceof PLOEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ploEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ploEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in ploEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom PLOEntry implementation " + ploEntry.getClass());
        }
        PLOEntryModelImpl ploEntryModelImpl = (PLOEntryModelImpl)ploEntry;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && ploEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                ploEntry.setCreateDate(date);
            } else {
                ploEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!ploEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                ploEntry.setModifiedDate(date);
            } else {
                ploEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        if ((userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
            long companyId = ploEntry.getCompanyId();
            long groupId = 0L;
            long ploEntryId = 0L;
            if (!isNew) {
                ploEntryId = ploEntry.getPrimaryKey();
            }
            try {
                ploEntry.setValue(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)PLOEntry.class.getName(), (long)ploEntryId, (String)"text/html", (String)"ALL", (String)ploEntry.getValue(), null));
            }
            catch (SanitizerException sanitizerException) {
                throw new SystemException((Throwable)sanitizerException);
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ploEntry);
            } else {
                ploEntry = (PLOEntry)session.merge((Object)ploEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(PLOEntryImpl.class, (BaseModel)ploEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(ploEntryModelImpl);
        if (isNew) {
            ploEntry.setNew(false);
        }
        ploEntry.resetOriginalValues();
        return ploEntry;
    }

    public PLOEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchPLOEntryException {
        PLOEntry ploEntry = (PLOEntry)this.fetchByPrimaryKey(primaryKey);
        if (ploEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchPLOEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ploEntry;
    }

    public PLOEntry findByPrimaryKey(long ploEntryId) throws NoSuchPLOEntryException {
        return this.findByPrimaryKey(Long.valueOf(ploEntryId));
    }

    public PLOEntry fetchByPrimaryKey(long ploEntryId) {
        return (PLOEntry)this.fetchByPrimaryKey(Long.valueOf(ploEntryId));
    }

    public List<PLOEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<PLOEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<PLOEntry> findAll(int start, int end, OrderByComparator<PLOEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<PLOEntry> findAll(int start, int end, OrderByComparator<PLOEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_PLOENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_PLOENTRY;
                sql = sql.concat(" ORDER BY ploEntry.key ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (PLOEntry ploEntry : this.findAll()) {
            this.remove((BaseModel)ploEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_PLOENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ploEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_PLOENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return PLOEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_K = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_K", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "key_"}, true);
        this._finderPathWithoutPaginationFindByC_K = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_K", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "key_"}, true);
        this._finderPathCountByC_K = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_K", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "key_"}, false);
        this._finderPathWithPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_L", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "languageId"}, true);
        this._finderPathWithoutPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_L", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "languageId"}, true);
        this._finderPathCountByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "languageId"}, false);
        this._finderPathFetchByC_K_L = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_K_L", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "key_", "languageId"}, true);
        PLOEntryUtil.setPersistence((PLOEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        PLOEntryUtil.setPersistence(null);
        this.entityCache.removeCache(PLOEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.portal.language.override.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.language.override.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.language.override.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

