/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.rest.internal.resource.v1_0;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.language.override.model.PLOEntry;
import com.liferay.portal.language.override.model.PLOEntryModel;
import com.liferay.portal.language.override.service.PLOEntryService;
import com.liferay.portal.language.rest.dto.v1_0.Message;
import com.liferay.portal.language.rest.internal.resource.v1_0.BaseMessageResourceImpl;
import com.liferay.portal.language.rest.resource.v1_0.MessageResource;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageResource.class})
public class MessageResourceImpl
extends BaseMessageResourceImpl {
    @Reference
    private Language _language;
    @Reference
    private PLOEntryService _ploEntryService;

    @Override
    public void deleteMessage(String key, String languageId) throws Exception {
        if (Validator.isNull((String)languageId)) {
            this._ploEntryService.deletePLOEntries(key);
        } else {
            this._ploEntryService.deletePLOEntry(key, languageId);
        }
    }

    @Override
    public Message getMessage(String key, String languageId) {
        Message message = new Message();
        message.setKey(() -> key);
        message.setLanguageId(() -> languageId);
        message.setValue(() -> this._language.get(LocaleUtil.fromLanguageId((String)languageId), key));
        return message;
    }

    @Override
    public Message postMessage(Message message) throws PortalException {
        return this._addOrUpdatePLOEntry(message);
    }

    @Override
    public void postMessageImport(String languageId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("Unable to read file");
        }
        if (!Objects.equals(FileUtil.getExtension((String)binaryFile.getFileName()), "properties")) {
            throw new BadRequestException("File name must have a \"properties\" file extension");
        }
        try (InputStream inputStream = binaryFile.getInputStream();
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            this._ploEntryService.importPLOEntries(languageId, properties);
        }
    }

    @Override
    public Message putMessage(Message message) throws PortalException {
        return this._addOrUpdatePLOEntry(message);
    }

    @Override
    public Page<Message> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        List keys = this.transform(this._ploEntryService.getPLOEntries(this.contextCompany.getCompanyId()), PLOEntryModel::getKey);
        String languageId = GetterUtil.getString((Object)parameters.get("languageId"));
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)true));
        keys.addAll(resourceBundle.keySet());
        Collections.sort(keys);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = pagination.getStartPosition(); i < keys.size() && i < pagination.getEndPosition(); ++i) {
            Message message = new Message();
            String key = (String)keys.get(i);
            message.setKey(() -> key);
            message.setLanguageId(() -> languageId);
            message.setValue(() -> ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key));
            messages.add(message);
            if (i >= pagination.getEndPosition()) break;
        }
        return Page.of(messages, (Pagination)pagination, (long)keys.size());
    }

    private Message _addOrUpdatePLOEntry(Message message) throws PortalException {
        PLOEntry ploEntry = this._ploEntryService.addOrUpdatePLOEntry(message.getKey(), message.getLanguageId(), message.getValue());
        message.setKey(() -> ((PLOEntry)ploEntry).getKey());
        message.setLanguageId(() -> ((PLOEntry)ploEntry).getLanguageId());
        message.setValue(() -> ((PLOEntry)ploEntry).getValue());
        return message;
    }
}

