/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.deployer.internal.installer;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.File;
import java.net.URL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={FileInstaller.class})
public class LicenseInstaller
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(LicenseInstaller.class);
    @Reference(target="(module.service.lifecycle=license.install)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    public boolean canTransformURL(File artifact) {
        block4: {
            String extension = FileUtil.getExtension((String)artifact.getName());
            if (!extension.equals("xml")) {
                return false;
            }
            try {
                String content = FileUtil.read((File)artifact);
                Document document = SAXReaderUtil.read((String)content);
                Element rootElement = document.getRootElement();
                String rootElementName = rootElement.getName();
                if (rootElementName.equals("license") || rootElementName.equals("licenses")) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return false;
    }

    public URL transformURL(File file) throws Exception {
        String content = FileUtil.read((File)file);
        JSONObject jsonObject = JSONUtil.put((String)"licenseXML", (Object)content);
        LicenseManagerUtil.registerLicense((JSONObject)jsonObject);
        return null;
    }

    public void uninstall(File file) {
    }
}

