/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lock.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.ExpiredLockException;
import com.liferay.portal.kernel.lock.InvalidLockException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.lock.NoSuchLockException;
import com.liferay.portal.lock.exception.DuplicateLockException;
import com.liferay.portal.lock.internal.LockImpl;
import com.liferay.portal.lock.model.Lock;
import com.liferay.portal.lock.service.LockLocalService;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LockManager.class})
public class LockManagerImpl
implements LockManager {
    private LockLocalService _lockLocalService;

    public void clear() {
        this._lockLocalService.clear();
    }

    public com.liferay.portal.kernel.lock.Lock createLock(long lockId, long companyId, long userId, String userName) {
        Lock lock = this._lockLocalService.createLock(lockId);
        lock.setCompanyId(companyId);
        lock.setUserId(userId);
        lock.setUserName(userName);
        lock.setCreateDate(new Date());
        return new LockImpl(lock);
    }

    public com.liferay.portal.kernel.lock.Lock fetchLock(String className, long key) {
        Lock lock = this._lockLocalService.fetchLock(className, key);
        if (lock == null) {
            return null;
        }
        return new LockImpl(lock);
    }

    public com.liferay.portal.kernel.lock.Lock fetchLock(String className, String key) {
        Lock lock = this._lockLocalService.fetchLock(className, key);
        if (lock == null) {
            return null;
        }
        return new LockImpl(lock);
    }

    public com.liferay.portal.kernel.lock.Lock getLock(String className, long key) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.getLock(className, key));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public com.liferay.portal.kernel.lock.Lock getLock(String className, String key) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.getLock(className, key));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public com.liferay.portal.kernel.lock.Lock getLockByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.getLockByUuidAndCompanyId(uuid, companyId));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public boolean hasLock(long userId, String className, long key) {
        return this._lockLocalService.hasLock(userId, className, key);
    }

    public boolean hasLock(long userId, String className, String key) {
        return this._lockLocalService.hasLock(userId, className, key);
    }

    public boolean isLocked(String className, long key) {
        return this._lockLocalService.isLocked(className, key);
    }

    public boolean isLocked(String className, String key) {
        return this._lockLocalService.isLocked(className, key);
    }

    public com.liferay.portal.kernel.lock.Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.lock(userId, className, key, owner, inheritable, expirationTime, true);
    }

    public com.liferay.portal.kernel.lock.Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.lock(userId, className, key, owner, inheritable, expirationTime, renew));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public com.liferay.portal.kernel.lock.Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.lock(userId, className, key, owner, inheritable, expirationTime, true);
    }

    public com.liferay.portal.kernel.lock.Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.lock(userId, className, key, owner, inheritable, expirationTime, renew));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public com.liferay.portal.kernel.lock.Lock lock(String className, String key, String owner) {
        return new LockImpl(this._lockLocalService.lock(className, key, owner));
    }

    public com.liferay.portal.kernel.lock.Lock lock(String className, String key, String expectedOwner, String updatedOwner) {
        return new LockImpl(this._lockLocalService.lock(className, key, expectedOwner, updatedOwner));
    }

    public com.liferay.portal.kernel.lock.Lock refresh(String uuid, long companyId, long expirationTime) throws PortalException {
        try {
            return new LockImpl(this._lockLocalService.refresh(uuid, companyId, expirationTime));
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public void unlock(String className, long key) {
        this._lockLocalService.unlock(className, key);
    }

    public void unlock(String className, String key) {
        this._lockLocalService.unlock(className, key);
    }

    public void unlock(String className, String key, String owner) {
        this._lockLocalService.unlock(className, key, owner);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.clear();
    }

    @Reference(unbind="-")
    protected void setLockLocalService(LockLocalService lockLocalService) {
        this._lockLocalService = lockLocalService;
    }

    private PortalException _translate(PortalException portalException) {
        if (portalException instanceof DuplicateLockException) {
            DuplicateLockException duplicateLockException = (DuplicateLockException)portalException;
            return new com.liferay.portal.kernel.lock.DuplicateLockException((com.liferay.portal.kernel.lock.Lock)new LockImpl(duplicateLockException.getLock()));
        }
        Throwable throwable = portalException.getCause();
        String message = portalException.getMessage();
        if (portalException instanceof com.liferay.portal.lock.exception.ExpiredLockException) {
            if (throwable == null) {
                return new ExpiredLockException(message);
            }
            return new ExpiredLockException(message, throwable);
        }
        if (portalException instanceof com.liferay.portal.lock.exception.InvalidLockException) {
            if (throwable == null) {
                return new InvalidLockException(message);
            }
            return new InvalidLockException(message, throwable);
        }
        if (portalException instanceof com.liferay.portal.lock.exception.NoSuchLockException) {
            if (throwable == null) {
                return new NoSuchLockException(message);
            }
            return new NoSuchLockException(message, throwable);
        }
        return portalException;
    }
}

