/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lock.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.dao.jdbc.aop.MasterDataSource;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.lock.exception.DuplicateLockException;
import com.liferay.portal.lock.exception.ExpiredLockException;
import com.liferay.portal.lock.exception.NoSuchLockException;
import com.liferay.portal.lock.model.Lock;
import com.liferay.portal.lock.service.base.LockLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.PersistenceException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(property={"model.class.name=com.liferay.portal.lock.model.Lock"}, service={AopService.class})
public class LockLocalServiceImpl
extends LockLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LockLocalServiceImpl.class);
    private ServiceTrackerMap<String, LockListener> _serviceTrackerMap;
    private final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private UserLocalService _userLocalService;

    public void clear() {
        this.lockPersistence.removeByLtExpirationDate(new Date());
    }

    public Lock fetchLock(String className, long key) {
        return this.fetchLock(className, String.valueOf(key));
    }

    public Lock fetchLock(String className, String key) {
        if (this.lockPersistence.countByClassName(className) == 0) {
            return null;
        }
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null && lock.isExpired()) {
            this.expireLock(lock);
            lock = null;
        }
        return lock;
    }

    public Lock getLock(String className, long key) throws PortalException {
        return this.getLock(className, String.valueOf(key));
    }

    public Lock getLock(String className, String key) throws PortalException {
        if (this.lockPersistence.countByClassName(className) == 0) {
            throw new NoSuchLockException(StringBundler.concat((String[])new String[]{"No Lock exists with the key {className=", className, ", key=", key, "}"}));
        }
        Lock lock = this.lockPersistence.findByC_K(className, key);
        if (lock.isExpired()) {
            this.expireLock(lock);
            throw new ExpiredLockException();
        }
        return lock;
    }

    public boolean hasLock(long userId, String className, long key) {
        return this.hasLock(userId, className, String.valueOf(key));
    }

    public boolean hasLock(long userId, String className, String key) {
        Lock lock = this.fetchLock(className, key);
        return lock != null && lock.getUserId() == userId;
    }

    public boolean isLocked(String className, long key) {
        return this.isLocked(className, String.valueOf(key));
    }

    public boolean isLocked(String className, String key) {
        Lock lock = this.fetchLock(className, key);
        return lock != null;
    }

    public Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.lock(userId, className, String.valueOf(key), owner, inheritable, expirationTime);
    }

    public Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        return this.lock(userId, className, String.valueOf(key), owner, inheritable, expirationTime, renew);
    }

    public Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.lock(userId, className, key, owner, inheritable, expirationTime, true);
    }

    public Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null) {
            if (lock.isExpired()) {
                this.expireLock(lock);
                lock = null;
            } else if (lock.getUserId() != userId) {
                throw new DuplicateLockException(lock);
            }
        }
        boolean isNew = false;
        if (lock == null) {
            User user = this._userLocalService.getUser(userId);
            long lockId = this.counterLocalService.increment();
            lock = this.lockPersistence.create(lockId);
            lock.setCompanyId(user.getCompanyId());
            lock.setUserId(user.getUserId());
            lock.setUserName(user.getFullName());
            lock.setClassName(className);
            lock.setKey(key);
            lock.setOwner(owner);
            lock.setInheritable(inheritable);
            isNew = true;
        } else if (!renew) {
            return lock;
        }
        Date date = new Date();
        lock.setCreateDate(date);
        if (expirationTime == 0L) {
            lock.setExpirationDate(null);
        } else {
            lock.setExpirationDate(new Date(date.getTime() + expirationTime));
        }
        lock = (Lock)this.lockPersistence.update((BaseModel)lock);
        if (isNew) {
            lock.setNew(true);
        }
        return lock;
    }

    @MasterDataSource
    public Lock lock(String className, String key, String owner) {
        return this.lock(className, key, null, owner);
    }

    @MasterDataSource
    public Lock lock(String className, String key, String expectedOwner, String updatedOwner) {
        while (true) {
            try {
                return (Lock)TransactionInvokerUtil.invoke((TransactionConfig)this._transactionConfig, () -> {
                    Lock lock = this.lockPersistence.fetchByC_K(className, key, false);
                    if (lock == null) {
                        long lockId = this.counterLocalService.increment();
                        lock = this.lockPersistence.create(lockId);
                        lock.setCreateDate(new Date());
                        lock.setClassName(className);
                        lock.setKey(key);
                        lock.setOwner(updatedOwner);
                        lock = (Lock)this.lockPersistence.update((BaseModel)lock);
                        lock.setNew(true);
                    } else if (Objects.equals(lock.getOwner(), expectedOwner)) {
                        lock.setCreateDate(new Date());
                        lock.setClassName(className);
                        lock.setKey(key);
                        lock.setOwner(updatedOwner);
                        lock = (Lock)this.lockPersistence.update((BaseModel)lock);
                        lock.setNew(true);
                    }
                    return lock;
                });
            }
            catch (Throwable throwable) {
                Throwable causeThrowable = throwable;
                if (throwable instanceof ORMException || throwable instanceof PersistenceException) {
                    causeThrowable = throwable.getCause();
                }
                if (causeThrowable instanceof ConstraintViolationException || causeThrowable instanceof LockAcquisitionException) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)"Unable to acquire lock, retrying");
                    continue;
                }
                ReflectionUtil.throwException((Throwable)throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock refresh(String uuid, long companyId, long expirationTime) throws PortalException {
        List locks = this.lockPersistence.findByUuid_C(uuid, companyId);
        if (locks.isEmpty()) {
            throw new NoSuchLockException(StringBundler.concat((Object[])new Object[]{"{uuid=", uuid, ", companyId=", companyId, "}"}));
        }
        Lock lock = (Lock)locks.get(0);
        LockListener lockListener = this._getLockListener(lock.getClassName());
        String key = lock.getKey();
        if (lockListener != null) {
            lockListener.onBeforeRefresh(key);
        }
        try {
            Date date = new Date();
            lock.setCreateDate(date);
            if (expirationTime == 0L) {
                lock.setExpirationDate(null);
            } else {
                lock.setExpirationDate(new Date(date.getTime() + expirationTime));
            }
            Lock lock2 = (Lock)this.lockPersistence.update((BaseModel)lock);
            return lock2;
        }
        finally {
            if (lockListener != null) {
                lockListener.onAfterRefresh(key);
            }
        }
    }

    public void unlock(String className, long key) {
        this.unlock(className, String.valueOf(key));
    }

    public void unlock(String className, String key) {
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null) {
            this.lockPersistence.remove((BaseModel)lock);
        }
    }

    @MasterDataSource
    public void unlock(String className, String key, String owner) {
        while (true) {
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)this._transactionConfig, () -> {
                    Lock lock = this.lockPersistence.fetchByC_K(className, key, false);
                    if (lock == null) {
                        return null;
                    }
                    if (Objects.equals(lock.getOwner(), owner)) {
                        this.lockPersistence.remove((BaseModel)lock);
                    }
                    return null;
                });
                return;
            }
            catch (Throwable throwable) {
                Throwable causeThrowable = throwable;
                if (throwable instanceof ORMException) {
                    causeThrowable = throwable.getCause();
                }
                if (causeThrowable instanceof ConstraintViolationException || causeThrowable instanceof LockAcquisitionException) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)"Unable to remove lock, retrying");
                    continue;
                }
                ReflectionUtil.throwException((Throwable)throwable);
                continue;
            }
            break;
        }
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        if (this._serviceTrackerMap != null) {
            this._serviceTrackerMap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireLock(Lock lock) {
        LockListener lockListener = this._getLockListener(lock.getClassName());
        String key = lock.getKey();
        if (lockListener != null) {
            lockListener.onBeforeExpire(key);
        }
        try {
            this.lockPersistence.remove((BaseModel)lock);
            this.lockPersistence.flush();
        }
        finally {
            if (lockListener != null) {
                lockListener.onAfterExpire(key);
            }
        }
    }

    private LockListener _getLockListener(String className) {
        if (this._serviceTrackerMap == null) {
            Bundle bundle = FrameworkUtil.getBundle(LockLocalServiceImpl.class);
            BundleContext bundleContext = bundle.getBundleContext();
            this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, LockListener.class, null, (serviceReference, emitter) -> {
                LockListener lockListener = (LockListener)bundleContext.getService(serviceReference);
                emitter.emit((Object)lockListener.getClassName());
            });
        }
        return (LockListener)this._serviceTrackerMap.getService((Object)className);
    }
}

