/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lock.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.lock.exception.NoSuchLockException;
import com.liferay.portal.lock.model.Lock;
import com.liferay.portal.lock.model.LockTable;
import com.liferay.portal.lock.model.impl.LockImpl;
import com.liferay.portal.lock.model.impl.LockModelImpl;
import com.liferay.portal.lock.service.persistence.LockPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LockPersistence.class, BasePersistence.class})
public class LockPersistenceImpl
extends BasePersistenceImpl<Lock>
implements LockPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LockImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "lock_.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(lock_.uuid IS NULL OR lock_.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "lock_.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(lock_.uuid IS NULL OR lock_.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "lock_.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByClassName;
    private FinderPath _finderPathWithoutPaginationFindByClassName;
    private FinderPath _finderPathCountByClassName;
    private static final String _FINDER_COLUMN_CLASSNAME_CLASSNAME_2 = "lock_.className = ?";
    private static final String _FINDER_COLUMN_CLASSNAME_CLASSNAME_3 = "(lock_.className IS NULL OR lock_.className = '')";
    private FinderPath _finderPathWithPaginationFindByLtExpirationDate;
    private FinderPath _finderPathWithPaginationCountByLtExpirationDate;
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1 = "lock_.expirationDate IS NULL";
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2 = "lock_.expirationDate < ?";
    private FinderPath _finderPathFetchByC_K;
    private FinderPath _finderPathCountByC_K;
    private static final String _FINDER_COLUMN_C_K_CLASSNAME_2 = "lock_.className = ? AND ";
    private static final String _FINDER_COLUMN_C_K_CLASSNAME_3 = "(lock_.className IS NULL OR lock_.className = '') AND ";
    private static final String _FINDER_COLUMN_C_K_KEY_2 = "lock_.key = ?";
    private static final String _FINDER_COLUMN_C_K_KEY_3 = "(lock_.key IS NULL OR lock_.key = '')";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_LOCK_ = "SELECT lock_ FROM Lock lock_";
    private static final String _SQL_SELECT_LOCK__WHERE = "SELECT lock_ FROM Lock lock_ WHERE ";
    private static final String _SQL_COUNT_LOCK_ = "SELECT COUNT(lock_) FROM Lock lock_";
    private static final String _SQL_COUNT_LOCK__WHERE = "SELECT COUNT(lock_) FROM Lock lock_ WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "lock_.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Lock exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Lock exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(LockPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "key"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<Lock> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Lock> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Lock> findByUuid(String uuid, int start, int end, OrderByComparator<Lock> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<Lock> findByUuid(String uuid, int start, int end, OrderByComparator<Lock> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Lock lock : list) {
                if (uuid.equals(lock.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LOCK__WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY lock_.lockId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Lock findByUuid_First(String uuid, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByUuid_First(uuid, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByUuid_First(String uuid, OrderByComparator<Lock> orderByComparator) {
        List<Lock> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock findByUuid_Last(String uuid, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByUuid_Last(uuid, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByUuid_Last(String uuid, OrderByComparator<Lock> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Lock> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock[] findByUuid_PrevAndNext(long lockId, String uuid, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        uuid = Objects.toString(uuid, "");
        Lock lock = this.findByPrimaryKey(lockId);
        Session session = null;
        try {
            session = this.openSession();
            Lock[] array = new LockImpl[]{this.getByUuid_PrevAndNext(session, lock, uuid, orderByComparator, true), lock, this.getByUuid_PrevAndNext(session, lock, uuid, orderByComparator, false)};
            Lock[] lockArray = array;
            return lockArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Lock getByUuid_PrevAndNext(Session session, Lock lock, String uuid, OrderByComparator<Lock> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LOCK__WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY lock_.lockId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)lock)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Lock)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (Lock lock : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)lock);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LOCK__WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Lock> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Lock> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Lock> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Lock> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<Lock> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Lock> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Lock lock : list) {
                if (uuid.equals(lock.getUuid()) && companyId == lock.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LOCK__WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY lock_.lockId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Lock findByUuid_C_First(String uuid, long companyId, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Lock> orderByComparator) {
        List<Lock> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Lock> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Lock> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock[] findByUuid_C_PrevAndNext(long lockId, String uuid, long companyId, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        uuid = Objects.toString(uuid, "");
        Lock lock = this.findByPrimaryKey(lockId);
        Session session = null;
        try {
            session = this.openSession();
            Lock[] array = new LockImpl[]{this.getByUuid_C_PrevAndNext(session, lock, uuid, companyId, orderByComparator, true), lock, this.getByUuid_C_PrevAndNext(session, lock, uuid, companyId, orderByComparator, false)};
            Lock[] lockArray = array;
            return lockArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Lock getByUuid_C_PrevAndNext(Session session, Lock lock, String uuid, long companyId, OrderByComparator<Lock> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LOCK__WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY lock_.lockId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)lock)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Lock)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (Lock lock : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)lock);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LOCK__WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Lock> findByClassName(String className) {
        return this.findByClassName(className, -1, -1, null);
    }

    public List<Lock> findByClassName(String className, int start, int end) {
        return this.findByClassName(className, start, end, null);
    }

    public List<Lock> findByClassName(String className, int start, int end, OrderByComparator<Lock> orderByComparator) {
        return this.findByClassName(className, start, end, orderByComparator, true);
    }

    public List<Lock> findByClassName(String className, int start, int end, OrderByComparator<Lock> orderByComparator, boolean useFinderCache) {
        className = Objects.toString(className, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByClassName;
                finderArgs = new Object[]{className};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByClassName;
            finderArgs = new Object[]{className, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Lock lock : list) {
                if (className.equals(lock.getClassName())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LOCK__WHERE);
            boolean bindClassName = false;
            if (className.isEmpty()) {
                sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_3);
            } else {
                bindClassName = true;
                sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY lock_.lockId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindClassName) {
                    queryPos.add(className);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Lock findByClassName_First(String className, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByClassName_First(className, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("className=");
        sb.append(className);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByClassName_First(String className, OrderByComparator<Lock> orderByComparator) {
        List<Lock> list = this.findByClassName(className, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock findByClassName_Last(String className, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByClassName_Last(className, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("className=");
        sb.append(className);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByClassName_Last(String className, OrderByComparator<Lock> orderByComparator) {
        int count = this.countByClassName(className);
        if (count == 0) {
            return null;
        }
        List<Lock> list = this.findByClassName(className, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock[] findByClassName_PrevAndNext(long lockId, String className, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        className = Objects.toString(className, "");
        Lock lock = this.findByPrimaryKey(lockId);
        Session session = null;
        try {
            session = this.openSession();
            Lock[] array = new LockImpl[]{this.getByClassName_PrevAndNext(session, lock, className, orderByComparator, true), lock, this.getByClassName_PrevAndNext(session, lock, className, orderByComparator, false)};
            Lock[] lockArray = array;
            return lockArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Lock getByClassName_PrevAndNext(Session session, Lock lock, String className, OrderByComparator<Lock> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LOCK__WHERE);
        boolean bindClassName = false;
        if (className.isEmpty()) {
            sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_3);
        } else {
            bindClassName = true;
            sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY lock_.lockId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindClassName) {
            queryPos.add(className);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)lock)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Lock)list.get(1);
        }
        return null;
    }

    public void removeByClassName(String className) {
        for (Lock lock : this.findByClassName(className, -1, -1, null)) {
            this.remove((BaseModel)lock);
        }
    }

    public int countByClassName(String className) {
        className = Objects.toString(className, "");
        FinderPath finderPath = this._finderPathCountByClassName;
        Object[] finderArgs = new Object[]{className};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LOCK__WHERE);
            boolean bindClassName = false;
            if (className.isEmpty()) {
                sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_3);
            } else {
                bindClassName = true;
                sb.append(_FINDER_COLUMN_CLASSNAME_CLASSNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindClassName) {
                    queryPos.add(className);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Lock> findByLtExpirationDate(Date expirationDate) {
        return this.findByLtExpirationDate(expirationDate, -1, -1, null);
    }

    public List<Lock> findByLtExpirationDate(Date expirationDate, int start, int end) {
        return this.findByLtExpirationDate(expirationDate, start, end, null);
    }

    public List<Lock> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<Lock> orderByComparator) {
        return this.findByLtExpirationDate(expirationDate, start, end, orderByComparator, true);
    }

    public List<Lock> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<Lock> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtExpirationDate;
        finderArgs = new Object[]{LockPersistenceImpl._getTime(expirationDate), start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (Lock lock : list) {
                if (expirationDate.getTime() > lock.getExpirationDate().getTime()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LOCK__WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY lock_.lockId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Lock findByLtExpirationDate_First(Date expirationDate, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByLtExpirationDate_First(expirationDate, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByLtExpirationDate_First(Date expirationDate, OrderByComparator<Lock> orderByComparator) {
        List<Lock> list = this.findByLtExpirationDate(expirationDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock findByLtExpirationDate_Last(Date expirationDate, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.fetchByLtExpirationDate_Last(expirationDate, orderByComparator);
        if (lock != null) {
            return lock;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchLockException(sb.toString());
    }

    public Lock fetchByLtExpirationDate_Last(Date expirationDate, OrderByComparator<Lock> orderByComparator) {
        int count = this.countByLtExpirationDate(expirationDate);
        if (count == 0) {
            return null;
        }
        List<Lock> list = this.findByLtExpirationDate(expirationDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Lock[] findByLtExpirationDate_PrevAndNext(long lockId, Date expirationDate, OrderByComparator<Lock> orderByComparator) throws NoSuchLockException {
        Lock lock = this.findByPrimaryKey(lockId);
        Session session = null;
        try {
            session = this.openSession();
            Lock[] array = new LockImpl[]{this.getByLtExpirationDate_PrevAndNext(session, lock, expirationDate, orderByComparator, true), lock, this.getByLtExpirationDate_PrevAndNext(session, lock, expirationDate, orderByComparator, false)};
            Lock[] lockArray = array;
            return lockArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Lock getByLtExpirationDate_PrevAndNext(Session session, Lock lock, Date expirationDate, OrderByComparator<Lock> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LOCK__WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY lock_.lockId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindExpirationDate) {
            queryPos.add(new Timestamp(expirationDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)lock)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Lock)list.get(1);
        }
        return null;
    }

    public void removeByLtExpirationDate(Date expirationDate) {
        for (Lock lock : this.findByLtExpirationDate(expirationDate, -1, -1, null)) {
            this.remove((BaseModel)lock);
        }
    }

    public int countByLtExpirationDate(Date expirationDate) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtExpirationDate;
        Object[] finderArgs = new Object[]{LockPersistenceImpl._getTime(expirationDate)};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LOCK__WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Lock findByC_K(String className, String key) throws NoSuchLockException {
        Lock lock = this.fetchByC_K(className, key);
        if (lock == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("className=");
            sb.append(className);
            sb.append(", key=");
            sb.append(key);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLockException(sb.toString());
        }
        return lock;
    }

    public Lock fetchByC_K(String className, String key) {
        return this.fetchByC_K(className, key, true);
    }

    public Lock fetchByC_K(String className, String key, boolean useFinderCache) {
        Lock lock;
        className = Objects.toString(className, "");
        key = Objects.toString(key, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{className, key};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_K, finderArgs);
        }
        if (!(!(result instanceof Lock) || Objects.equals(className, (lock = (Lock)result).getClassName()) && Objects.equals(key, lock.getKey()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LOCK__WHERE);
            boolean bindClassName = false;
            if (className.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_CLASSNAME_3);
            } else {
                bindClassName = true;
                sb.append(_FINDER_COLUMN_C_K_CLASSNAME_2);
            }
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_C_K_KEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindClassName) {
                    queryPos.add(className);
                }
                if (bindKey) {
                    queryPos.add(key);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_K, finderArgs, (Object)list);
                    }
                } else {
                    Lock lock2 = (Lock)list.get(0);
                    result = lock2;
                    this.cacheResult(lock2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Lock)result;
    }

    public Lock removeByC_K(String className, String key) throws NoSuchLockException {
        Lock lock = this.findByC_K(className, key);
        return (Lock)this.remove((BaseModel)lock);
    }

    public int countByC_K(String className, String key) {
        className = Objects.toString(className, "");
        key = Objects.toString(key, "");
        FinderPath finderPath = this._finderPathCountByC_K;
        Object[] finderArgs = new Object[]{className, key};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LOCK__WHERE);
            boolean bindClassName = false;
            if (className.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_CLASSNAME_3);
            } else {
                bindClassName = true;
                sb.append(_FINDER_COLUMN_C_K_CLASSNAME_2);
            }
            boolean bindKey = false;
            if (key.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_K_KEY_3);
            } else {
                bindKey = true;
                sb.append(_FINDER_COLUMN_C_K_KEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindClassName) {
                    queryPos.add(className);
                }
                if (bindKey) {
                    queryPos.add(key);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LockPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("key", "key_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Lock.class);
        this.setModelImplClass(LockImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)LockTable.INSTANCE);
    }

    public void cacheResult(Lock lock) {
        this.entityCache.putResult(LockImpl.class, (Serializable)Long.valueOf(lock.getPrimaryKey()), (Serializable)lock);
        this.finderCache.putResult(this._finderPathFetchByC_K, new Object[]{lock.getClassName(), lock.getKey()}, (Object)lock);
    }

    public void cacheResult(List<Lock> locks) {
        for (Lock lock : locks) {
            if (this.entityCache.getResult(LockImpl.class, (Serializable)Long.valueOf(lock.getPrimaryKey())) != null) continue;
            this.cacheResult(lock);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(LockImpl.class);
        this.finderCache.clearCache(LockImpl.class);
    }

    public void clearCache(Lock lock) {
        this.entityCache.removeResult(LockImpl.class, (BaseModel)lock);
    }

    public void clearCache(List<Lock> locks) {
        for (Lock lock : locks) {
            this.entityCache.removeResult(LockImpl.class, (BaseModel)lock);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(LockImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(LockImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LockModelImpl lockModelImpl) {
        Object[] args = new Object[]{lockModelImpl.getClassName(), lockModelImpl.getKey()};
        this.finderCache.putResult(this._finderPathCountByC_K, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_K, args, (Object)lockModelImpl);
    }

    public Lock create(long lockId) {
        LockImpl lock = new LockImpl();
        lock.setNew(true);
        lock.setPrimaryKey(lockId);
        String uuid = PortalUUIDUtil.generate();
        lock.setUuid(uuid);
        lock.setCompanyId(CompanyThreadLocal.getCompanyId());
        return lock;
    }

    public Lock remove(long lockId) throws NoSuchLockException {
        return this.remove(Long.valueOf(lockId));
    }

    public Lock remove(Serializable primaryKey) throws NoSuchLockException {
        Session session = null;
        try {
            session = this.openSession();
            Lock lock = (Lock)session.get(LockImpl.class, primaryKey);
            if (lock == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchLockException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Lock lock2 = (Lock)this.remove((BaseModel)lock);
            return lock2;
        }
        catch (NoSuchLockException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Lock removeImpl(Lock lock) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)lock)) {
                lock = (Lock)session.get(LockImpl.class, lock.getPrimaryKeyObj());
            }
            if (lock != null) {
                session.delete((Object)lock);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (lock != null) {
            this.clearCache(lock);
        }
        return lock;
    }

    public Lock updateImpl(Lock lock) {
        boolean isNew = lock.isNew();
        if (!(lock instanceof LockModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(lock.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)lock);
                throw new IllegalArgumentException("Implement ModelWrapper in lock proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Lock implementation " + lock.getClass());
        }
        LockModelImpl lockModelImpl = (LockModelImpl)lock;
        if (Validator.isNull((String)lock.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            lock.setUuid(uuid);
        }
        if (isNew && lock.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                lock.setCreateDate(date);
            } else {
                lock.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)lock);
            } else {
                lock = (Lock)session.merge((Object)lock);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(LockImpl.class, (BaseModel)lockModelImpl, false, true);
        this.cacheUniqueFindersCache(lockModelImpl);
        if (isNew) {
            lock.setNew(false);
        }
        lock.resetOriginalValues();
        return lock;
    }

    public Lock findByPrimaryKey(Serializable primaryKey) throws NoSuchLockException {
        Lock lock = (Lock)this.fetchByPrimaryKey(primaryKey);
        if (lock == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchLockException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return lock;
    }

    public Lock findByPrimaryKey(long lockId) throws NoSuchLockException {
        return this.findByPrimaryKey(Long.valueOf(lockId));
    }

    public Lock fetchByPrimaryKey(long lockId) {
        return (Lock)this.fetchByPrimaryKey(Long.valueOf(lockId));
    }

    public List<Lock> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Lock> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Lock> findAll(int start, int end, OrderByComparator<Lock> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Lock> findAll(int start, int end, OrderByComparator<Lock> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_LOCK_);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_LOCK_;
                sql = sql.concat(" ORDER BY lock_.lockId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Lock lock : this.findAll()) {
            this.remove((BaseModel)lock);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_LOCK_);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "lockId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LOCK_;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return LockModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new LockModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByClassName = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByClassName", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"className"}, true);
        this._finderPathWithoutPaginationFindByClassName = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByClassName", new String[]{String.class.getName()}, new String[]{"className"}, true);
        this._finderPathCountByClassName = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassName", new String[]{String.class.getName()}, new String[]{"className"}, false);
        this._finderPathWithPaginationFindByLtExpirationDate = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtExpirationDate", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"expirationDate"}, true);
        this._finderPathWithPaginationCountByLtExpirationDate = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtExpirationDate", new String[]{Date.class.getName()}, new String[]{"expirationDate"}, false);
        this._finderPathFetchByC_K = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_K", new String[]{String.class.getName(), String.class.getName()}, new String[]{"className", "key_"}, true);
        this._finderPathCountByC_K = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_K", new String[]{String.class.getName(), String.class.getName()}, new String[]{"className", "key_"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(LockImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.portal.lock.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.lock.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.lock.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class LockModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private LockModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            LockModelImpl lockModelImpl = (LockModelImpl)baseModel;
            long columnBitmask = lockModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return LockModelArgumentsResolver._getValue(lockModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | LockModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return LockModelArgumentsResolver._getValue(lockModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return LockImpl.class.getName();
        }

        public String getTableName() {
            return LockTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(LockModelImpl lockModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? lockModelImpl.getColumnOriginalValue(columnName) : lockModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

