/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.extender.internal.activator;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.log4j.Log4JUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

public class Log4jExtenderBundleActivator
implements BundleActivator {
    private static final Log _log = LogFactoryUtil.getLog(Log4jExtenderBundleActivator.class);
    private volatile BundleTracker<Bundle> _bundleTracker;

    public void start(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker<Bundle>(bundleContext, 40, null){

            public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                Log4jExtenderBundleActivator.this._configureLog4j(bundle, "module-log4j.xml");
                Log4jExtenderBundleActivator.this._configureLog4j(bundle, "module-log4j-ext.xml");
                Log4jExtenderBundleActivator.this._configureLog4j(bundle.getSymbolicName());
                return bundle;
            }
        };
        this._bundleTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this._bundleTracker.close();
    }

    private void _configureLog4j(Bundle bundle, String resourcePath) {
        Enumeration enumeration = bundle.findEntries("META-INF", resourcePath, false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Log4JUtil.configureLog4J((URL)((URL)enumeration.nextElement()));
            }
        }
    }

    private void _configureLog4j(String symbolicName) {
        File configFile = new File(StringBundler.concat((String[])new String[]{PropsValues.MODULE_FRAMEWORK_BASE_DIR, "/log4j/", symbolicName, "-log4j-ext.xml"}));
        if (!configFile.exists()) {
            return;
        }
        URI uri = configFile.toURI();
        try {
            Log4JUtil.configureLog4J((URL)uri.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            _log.error((Object)("Unable to configure Log4j for bundle " + symbolicName), (Throwable)malformedURLException);
        }
    }
}

