/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.log4j.internal.CompanyLogRoutingFilePattern;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Constants;

@Plugin(category="Core", elementType="appender", name="CompanyLogRouting", printObject=true)
public final class CompanyLogRoutingAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "CompanyLogRouting";
    private static final boolean _COMPANY_LOG_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"company.log.enabled"));
    private final boolean _advertise;
    private final String _advertiseUri;
    private final boolean _append;
    private final Map<Long, List<Appender>> _appenders = new ConcurrentHashMap<Long, List<Appender>>();
    private final boolean _bufferedIo;
    private final int _bufferSize;
    private final CompanyLogRoutingFilePattern[] _companyLogRoutingFilePatterns;
    private final boolean _createOnDemand;
    private final String _dirPattern;
    private final String _fileGroup;
    private final String _fileName;
    private final String _fileOwner;
    private final String _filePermissions;
    private final boolean _immediateFlush;
    private final boolean _locking;
    private final RolloverStrategy _rolloverStrategy;
    private final TriggeringPolicy _triggeringPolicy;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void append(LogEvent logEvent) {
        if (!_COMPANY_LOG_ENABLED) {
            return;
        }
        List appenders = this._appenders.computeIfAbsent(CompanyThreadLocal.getCompanyId(), this::_createAppenders);
        appenders.forEach(appender -> appender.append(logEvent));
    }

    public File getCompanyLogDirectory(long companyId) {
        return new File(StringUtil.replace((String)this._dirPattern, (String)"@company.id@", (String)String.valueOf(companyId)));
    }

    private CompanyLogRoutingAppender(boolean advertise, String advertiseUri, boolean append, boolean bufferedIo, int bufferSize, CompanyLogRoutingFilePattern[] companyLogRoutingFilePatterns, boolean createOnDemand, String dirPattern, String fileGroup, String fileName, String fileOwner, String filePermissions, Filter filter, boolean immediateFlush, boolean locking, String name, RolloverStrategy rolloverStrategy, TriggeringPolicy triggeringPolicy) {
        super(name, filter, null, true, null);
        this._advertise = advertise;
        this._advertiseUri = advertiseUri;
        this._append = append;
        this._bufferedIo = bufferedIo;
        this._bufferSize = bufferSize;
        this._companyLogRoutingFilePatterns = companyLogRoutingFilePatterns;
        this._createOnDemand = createOnDemand;
        this._dirPattern = dirPattern;
        this._fileGroup = fileGroup;
        this._fileName = fileName;
        this._fileOwner = fileOwner;
        this._filePermissions = filePermissions;
        this._immediateFlush = immediateFlush;
        this._locking = locking;
        this._rolloverStrategy = rolloverStrategy;
        this._triggeringPolicy = triggeringPolicy;
    }

    private Appender _createAppender(Layout<?> layout, String filePattern, String name) {
        RollingFileAppender.Builder builder = RollingFileAppender.newBuilder();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext();
        builder.setConfiguration(loggerContext.getConfiguration());
        builder.setIgnoreExceptions(this.ignoreExceptions());
        builder.setLayout(layout);
        builder.setName(name);
        builder.withAdvertise(this._advertise);
        builder.withAdvertiseUri(this._advertiseUri);
        builder.withAppend(this._append);
        builder.withBufferedIo(this._bufferedIo);
        builder.withBufferSize(this._bufferSize);
        builder.withCreateOnDemand(this._createOnDemand);
        builder.withFileGroup(this._fileGroup);
        builder.withFileName(this._fileName);
        builder.withFileOwner(this._fileOwner);
        builder.withFilePattern(filePattern);
        builder.withFilePermissions(this._filePermissions);
        builder.withImmediateFlush(this._immediateFlush);
        builder.withLocking(this._locking);
        builder.withPolicy(this._triggeringPolicy);
        if (this._rolloverStrategy instanceof DirectWriteRolloverStrategy) {
            DirectWriteRolloverStrategy directWriteRolloverStrategy = (DirectWriteRolloverStrategy)this._rolloverStrategy;
            DirectWriteRolloverStrategy.Builder directWriteRolloverStrategyBuilder = DirectWriteRolloverStrategy.newBuilder();
            directWriteRolloverStrategyBuilder.withCompressionLevelStr(String.valueOf(directWriteRolloverStrategy.getCompressionLevel()));
            directWriteRolloverStrategyBuilder.withConfig(loggerContext.getConfiguration());
            List customActions = directWriteRolloverStrategy.getCustomActions();
            directWriteRolloverStrategyBuilder.withCustomActions(customActions.toArray(new Action[0]));
            directWriteRolloverStrategyBuilder.withMaxFiles(String.valueOf(directWriteRolloverStrategy.getMaxFiles()));
            directWriteRolloverStrategyBuilder.withStopCustomActionsOnError(directWriteRolloverStrategy.isStopCustomActionsOnError());
            PatternProcessor patternProcessor = directWriteRolloverStrategy.getTempCompressedFilePattern();
            if (patternProcessor != null) {
                directWriteRolloverStrategyBuilder.withTempCompressedFilePattern(patternProcessor.getPattern());
            }
            builder.withStrategy((RolloverStrategy)directWriteRolloverStrategyBuilder.build());
        } else {
            builder.withStrategy(this._rolloverStrategy);
        }
        RollingFileAppender appender = builder.build();
        if (appender != null) {
            appender.start();
            return appender;
        }
        return NullAppender.createAppender((String)name);
    }

    private List<Appender> _createAppenders(long companyId) {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        String appenderName = StringBundler.concat((Object[])new Object[]{companyId, "-", this.getName(), "-"});
        for (CompanyLogRoutingFilePattern companyLogRoutingFilePattern : this._companyLogRoutingFilePatterns) {
            Layout<?> layout = companyLogRoutingFilePattern.getLayout();
            Class<?> layoutClass = layout.getClass();
            appenders.add(this._createAppender(layout, StringUtil.replace((String)(this._dirPattern + "/" + companyLogRoutingFilePattern.getFileNamePattern()), (String)"@company.id@", (String)String.valueOf(companyId)), appenderName.concat(layoutClass.getSimpleName())));
        }
        return appenders;
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<CompanyLogRoutingAppender> {
        @PluginBuilderAttribute(value="advertise")
        private boolean _advertise;
        @PluginBuilderAttribute(value="advertiseUri")
        private String _advertiseUri;
        @PluginBuilderAttribute(value="append")
        private boolean _append = true;
        @PluginBuilderAttribute(value="bufferedIo")
        private boolean _bufferedIo = true;
        @PluginBuilderAttribute(value="bufferSize")
        private int _bufferSize = Constants.ENCODER_BYTE_BUFFER_SIZE;
        @PluginElement(value="FilePattern")
        @Required
        private CompanyLogRoutingFilePattern[] _companyLogRoutingFilePatterns;
        @PluginBuilderAttribute(value="createOnDemand")
        private boolean _createOnDemand;
        @PluginBuilderAttribute(value="dirPattern")
        @Required
        private String _dirPattern;
        @PluginBuilderAttribute(value="fileGroup")
        private String _fileGroup;
        @PluginBuilderAttribute(value="fileName")
        private String _fileName;
        @PluginBuilderAttribute(value="fileOwner")
        private String _fileOwner;
        @PluginBuilderAttribute(value="filePermissions")
        private String _filePermissions;
        @PluginBuilderAttribute(value="immediateFlush")
        private boolean _immediateFlush = true;
        @PluginBuilderAttribute(value="locking")
        private boolean _locking;
        @PluginElement(value="Strategy")
        private RolloverStrategy _rolloverStrategy;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy _triggeringPolicy;

        public CompanyLogRoutingAppender build() {
            return new CompanyLogRoutingAppender(this._advertise, this._advertiseUri, this._append, this._bufferedIo, this._bufferSize, this._companyLogRoutingFilePatterns, this._createOnDemand, this._dirPattern, this._fileGroup, this._fileName, this._fileOwner, this._filePermissions, this.getFilter(), this._immediateFlush, this._locking, this.getName(), this._rolloverStrategy, this._triggeringPolicy);
        }
    }
}

