/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.internal;

import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

@Plugin(category="Core", elementType="appender", name="CompanyWebIdConsole", printObject=true)
public final class CompanyWebIdConsoleAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "CompanyWebIdConsole";
    private Appender _appender;
    private final boolean _bufferedIo;
    private final int _bufferSize;
    private final boolean _direct;
    private final boolean _follow;
    private final boolean _immediateFlush;
    private final ConsoleAppender.Target _target;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void append(LogEvent logEvent) {
        long companyId;
        if (this._appender == null) {
            this._appender = this._createAppender();
        }
        if ((companyId = CompanyThreadLocal.getCompanyId().longValue()) == 0L || !ArrayUtil.contains((long[])PortalInstancePool.getCompanyIds(), (long)companyId)) {
            this._appender.append(logEvent);
            return;
        }
        MutableLogEvent mutableLogEvent = null;
        if (logEvent instanceof MutableLogEvent) {
            mutableLogEvent = (MutableLogEvent)logEvent;
            mutableLogEvent.setContextData((StringMap)new SortedArrayStringMap(logEvent.getContextData()));
        } else {
            mutableLogEvent = new MutableLogEvent();
            mutableLogEvent.initFrom(logEvent);
        }
        StringMap contextData = (StringMap)mutableLogEvent.getContextData();
        contextData.putValue("company.webId", (Object)PortalInstancePool.getWebId((long)companyId));
        this._appender.append((LogEvent)mutableLogEvent);
    }

    private CompanyWebIdConsoleAppender(boolean bufferedIo, int bufferSize, boolean direct, Filter filter, boolean follow, boolean immediateFlush, Layout<? extends Serializable> layout, String name, ConsoleAppender.Target target) {
        super(name, filter, layout, true, null);
        this._bufferedIo = bufferedIo;
        this._bufferSize = bufferSize;
        this._direct = direct;
        this._follow = follow;
        this._immediateFlush = immediateFlush;
        this._target = target;
    }

    private Appender _createAppender() {
        ConsoleAppender.Builder builder = ConsoleAppender.newBuilder();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext();
        builder.setConfiguration(loggerContext.getConfiguration());
        builder.setDirect(this._direct);
        builder.setFollow(this._follow);
        builder.setIgnoreExceptions(this.ignoreExceptions());
        builder.setLayout(this.getLayout());
        builder.setName(this.getName());
        builder.setTarget(this._target);
        builder.withBufferedIo(this._bufferedIo);
        builder.withBufferSize(this._bufferSize);
        builder.withImmediateFlush(this._immediateFlush);
        ConsoleAppender appender = builder.build();
        if (appender != null) {
            appender.start();
            return appender;
        }
        return NullAppender.createAppender((String)this.getName());
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<CompanyWebIdConsoleAppender> {
        @PluginBuilderAttribute(value="bufferedIo")
        private boolean _bufferedIo = true;
        @PluginBuilderAttribute(value="bufferSize")
        private int _bufferSize = Constants.ENCODER_BYTE_BUFFER_SIZE;
        @PluginBuilderAttribute(value="direct")
        private boolean _direct;
        @PluginBuilderAttribute(value="follow")
        private boolean _follow;
        @PluginBuilderAttribute(value="immediateFlush")
        private boolean _immediateFlush = true;
        @PluginBuilderAttribute(value="target")
        private ConsoleAppender.Target _target = ConsoleAppender.Target.SYSTEM_OUT;

        public CompanyWebIdConsoleAppender build() {
            return new CompanyWebIdConsoleAppender(this._bufferedIo, this._bufferSize, this._direct, this.getFilter(), this._follow, this._immediateFlush, this.getLayout(), this.getName(), this._target);
        }
    }
}

