/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.util.Transform;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

@Plugin(category="Core", elementType="layout", name="LiferayXmlLayout", printObject=true)
public final class LiferayXmlLayout
extends AbstractStringLayout {
    public static final String PLUGIN_NAME = "LiferayXmlLayout";
    private final boolean _locationInfo;
    private final boolean _properties;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        StringBuilder sb = LiferayXmlLayout.getStringBuilder();
        this._generateXMLLog(logEvent, sb);
        Encoder encoder = this.getStringBuilderEncoder();
        encoder.encode((Object)sb, byteBufferDestination);
    }

    public String toSerializable(LogEvent logEvent) {
        StringBuilder sb = LiferayXmlLayout.getStringBuilder();
        this._generateXMLLog(logEvent, sb);
        return sb.toString();
    }

    private LiferayXmlLayout(boolean locationInfo, boolean properties) {
        super(StandardCharsets.UTF_8);
        this._locationInfo = locationInfo;
        this._properties = properties;
    }

    private void _generateXMLLog(LogEvent logEvent, StringBuilder sb) {
        ReadOnlyStringMap contextMap;
        StackTraceElement stackTraceElement;
        Throwable throwable;
        sb.append("<log4j:event logger=\"");
        sb.append(Transform.escapeHtmlTags((String)logEvent.getLoggerName()));
        sb.append("\" timestamp=\"");
        sb.append(logEvent.getTimeMillis());
        sb.append("\" level=\"");
        sb.append(Transform.escapeHtmlTags((String)String.valueOf(logEvent.getLevel())));
        sb.append("\" thread=\"");
        sb.append(Transform.escapeHtmlTags((String)logEvent.getThreadName()));
        sb.append("\">");
        sb.append("\r\n");
        sb.append("<log4j:message>");
        sb.append("<![CDATA[");
        Message message = logEvent.getMessage();
        Transform.appendEscapingCData((StringBuilder)sb, (String)message.getFormattedMessage());
        sb.append("]]>");
        sb.append("</log4j:message>");
        sb.append("\r\n");
        ThreadContext.ContextStack contextStack = logEvent.getContextStack();
        List ndc = contextStack.asList();
        if (!ndc.isEmpty()) {
            sb.append("<log4j:NDC>");
            sb.append("<![CDATA[");
            Transform.appendEscapingCData((StringBuilder)sb, (String)Strings.join((Iterable)ndc, (char)' '));
            sb.append("]]>");
            sb.append("</log4j:NDC>");
            sb.append("\r\n");
        }
        if ((throwable = logEvent.getThrown()) != null) {
            sb.append("<log4j:throwable>");
            sb.append("<![CDATA[");
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            Transform.appendEscapingCData((StringBuilder)sb, (String)stringWriter.toString());
            sb.append("]]>");
            sb.append("</log4j:throwable>");
            sb.append("\r\n");
        }
        if (this._locationInfo && (stackTraceElement = logEvent.getSource()) != null) {
            sb.append("<log4j:locationInfo class=\"");
            sb.append(Transform.escapeHtmlTags((String)stackTraceElement.getClassName()));
            sb.append("\" method=\"");
            sb.append(Transform.escapeHtmlTags((String)stackTraceElement.getMethodName()));
            sb.append("\" file=\"");
            sb.append(Transform.escapeHtmlTags((String)stackTraceElement.getFileName()));
            sb.append("\" line=\"");
            sb.append(stackTraceElement.getLineNumber());
            sb.append("\"/>");
            sb.append("\r\n");
        }
        if (this._properties && !(contextMap = logEvent.getContextData()).isEmpty()) {
            sb.append("<log4j:properties>");
            sb.append("\r\n");
            contextMap.forEach((key, value) -> {
                if (value != null) {
                    sb.append("<log4j:data name=\"");
                    sb.append(Transform.escapeHtmlTags((String)key));
                    sb.append("\" value=\"");
                    sb.append(Transform.escapeHtmlTags((String)String.valueOf(value)));
                    sb.append("\"/>");
                    sb.append("\r\n");
                }
            });
            sb.append("</log4j:properties>");
            sb.append("\r\n");
        }
        sb.append("</log4j:event>");
        sb.append("\r\n");
        sb.append("\r\n");
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LiferayXmlLayout> {
        @PluginBuilderAttribute(value="locationInfo")
        private boolean _locationInfo;
        @PluginBuilderAttribute(value="properties")
        private boolean _properties;

        public LiferayXmlLayout build() {
            return new LiferayXmlLayout(this._locationInfo, this._properties);
        }
    }
}

