/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.internal;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.log4j.internal.CentralizedConfiguration;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Log4jConfigUtil {
    private static final Log _log = LogFactoryUtil.getLog(Log4jConfigUtil.class);
    private static final CentralizedConfiguration _centralizedConfiguration;
    private static final LoggerContext _loggerContext;

    public static Map<String, String> configureLog4J(String xmlContent, String ... removedAppenderNames) {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((Reader)new UnsyncStringReader(xmlContent));
            Element rootElement = document.getRootElement();
            if (!Objects.equals(rootElement.getName(), "Configuration")) {
                _log.error((Object)"Log4J 2 <Configuration> is required");
                return Collections.emptyMap();
            }
            if (!GetterUtil.getBoolean((String)rootElement.attributeValue("strict"))) {
                _log.error((Object)"<Configuration> strict attribute requires true");
                return Collections.emptyMap();
            }
            HashMap<String, String> priorities = new HashMap<String, String>();
            for (Element element : rootElement.elements()) {
                Log4jConfigUtil._removeAppender(element, removedAppenderNames);
                for (Element childElement : element.elements("Logger")) {
                    priorities.put(childElement.attributeValue("name"), childElement.attributeValue("level"));
                }
            }
            if (removedAppenderNames.length > 0) {
                xmlContent = document.asXML();
            }
            XmlConfiguration abstractConfiguration = new XmlConfiguration(_loggerContext, new ConfigurationSource((InputStream)new UnsyncByteArrayInputStream(xmlContent.getBytes("UTF-8")))){

                protected void setToDefault() {
                }
            };
            _centralizedConfiguration.addConfiguration((AbstractConfiguration)abstractConfiguration);
            return priorities;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return Collections.emptyMap();
        }
    }

    public static File getCompanyLogDirectory(long companyId) {
        return _centralizedConfiguration.getCompanyLogDirectory(companyId);
    }

    public static java.util.logging.Level getJDKLevel(String levelString) {
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.DEBUG.toString())) {
            return java.util.logging.Level.FINE;
        }
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.ERROR.toString())) {
            return java.util.logging.Level.SEVERE;
        }
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.WARN.toString())) {
            return java.util.logging.Level.WARNING;
        }
        return java.util.logging.Level.INFO;
    }

    public static Map<String, String> getPriorities() {
        HashMap<String, String> priorities = new HashMap<String, String>();
        Map loggerConfigs = _centralizedConfiguration.getLoggers();
        for (LoggerConfig loggerConfig : loggerConfigs.values()) {
            String loggerConfigName = loggerConfig.getName();
            if (Objects.equals(loggerConfigName, "")) continue;
            priorities.put(loggerConfigName, String.valueOf(loggerConfig.getLevel()));
        }
        return priorities;
    }

    public static void setLevel(String name, String priority) {
        Level level = Level.toLevel((String)priority);
        LoggerConfig loggerConfig = _centralizedConfiguration.getLogger(name);
        if (loggerConfig == null) {
            loggerConfig = new LoggerConfig(name, level, true);
            _centralizedConfiguration.addLogger(name, loggerConfig);
        } else {
            loggerConfig.setLevel(level);
        }
        _loggerContext.updateLoggers();
    }

    public static void shutdownLog4J() {
        LogManager.shutdown();
    }

    private static void _removeAppender(Element parentElement, String ... removedAppenderNames) {
        if (removedAppenderNames.length == 0) {
            return;
        }
        for (Element element : parentElement.elements()) {
            for (String appenderName : removedAppenderNames) {
                if (Objects.equals(element.getName(), "Appender") && Objects.equals(element.attributeValue("name"), appenderName)) {
                    parentElement.remove(element);
                }
                for (Element childElement : element.elements()) {
                    if (!Objects.equals(childElement.getName(), "AppenderRef") || !Objects.equals(childElement.attributeValue("ref"), appenderName)) continue;
                    element.remove(childElement);
                }
            }
        }
    }

    static {
        _loggerContext = LoggerContext.getContext();
        PluginManager.addPackage((String)"com.liferay.portal.log4j.internal");
        _centralizedConfiguration = new CentralizedConfiguration(_loggerContext);
        _loggerContext.setConfiguration((Configuration)_centralizedConfiguration);
    }
}

