/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ContainerLPKGUtil {
    private static final Log _log = LogFactoryUtil.getLog(ContainerLPKGUtil.class);

    public static List<File> deploy(File lpkgFile, Properties properties) throws IOException {
        ArrayList<File> lpkgFiles = new ArrayList<File>();
        try (ZipFile zipFile = new ZipFile(lpkgFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(".lpkg")) {
                    InputStream inputStream;
                    if (properties != null && (zipEntry = zipFile.getEntry("liferay-marketplace.properties")) != null) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        Throwable throwable = null;
                        try {
                            properties.load(inputStream);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                        }
                    }
                    inputStream = null;
                    return inputStream;
                }
                File deployerDir = new File(PropsValues.MODULE_FRAMEWORK_MARKETPLACE_DIR);
                File innerLPKGFile = new File(deployerDir, name);
                String innerLPKGCanonicalPath = innerLPKGFile.getCanonicalPath();
                if (!innerLPKGCanonicalPath.startsWith(deployerDir.getCanonicalPath() + File.separator)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Invalid LPKG File name: " + name));
                    continue;
                }
                Files.copy(zipFile.getInputStream(zipEntry), innerLPKGFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                lpkgFiles.add(innerLPKGFile);
            }
        }
        if (lpkgFiles.isEmpty()) {
            return null;
        }
        lpkgFile.delete();
        return lpkgFiles;
    }
}

