/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ModuleFrameworkPropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.ContainerLPKGUtil;
import com.liferay.portal.lpkg.deployer.internal.LPKGBundleTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.LPKGLocationUtil;
import com.liferay.portal.lpkg.deployer.internal.LPKGURLStreamHandlerService;
import com.liferay.portal.lpkg.deployer.internal.WABWrapperBundleTrackerCustomizer;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={LPKGDeployer.class})
public class DefaultLPKGDeployer
implements LPKGDeployer {
    private static final String _LPKG_OVERRIDE_PREFIX = "LPKG-Override::";
    private static final Log _log = LogFactoryUtil.getLog(DefaultLPKGDeployer.class);
    private Path _deploymentDirPath;
    private BundleTracker<List<Bundle>> _lpkgBundleTracker;
    @Reference
    private LPKGVerifier _lpkgVerifier;
    @Reference(target="(throwable.collector=initial.bundles)")
    private ThrowableCollector _throwableCollector;
    private final Map<String, URL> _urls = new ConcurrentHashMap<String, URL>();
    private BundleTracker<Bundle> _wabBundleTracker;

    public List<Bundle> deploy(BundleContext bundleContext, File lpkgFile) throws IOException {
        Path lpkgFilePath = (lpkgFile = lpkgFile.getCanonicalFile()).toPath();
        if (!lpkgFilePath.startsWith(this._deploymentDirPath)) {
            throw new LPKGVerifyException(StringBundler.concat((Object[])new Object[]{"Unable to deploy ", lpkgFile, " from outside the deployment directory ", this._deploymentDirPath}));
        }
        List oldBundles = this._lpkgVerifier.verify(lpkgFile);
        for (Bundle bundle : oldBundles) {
            try {
                String location;
                bundle.uninstall();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Uninstalled older LPKG bundle ", bundle, " in order to install ", lpkgFile}));
                }
                if ((location = LPKGLocationUtil.getLPKGLocation(lpkgFile)).equals(bundle.getLocation()) || !Files.deleteIfExists(Paths.get(bundle.getLocation(), new String[0])) || !_log.isInfoEnabled()) continue;
                _log.info((Object)("Removed old LPKG bundle " + bundle.getLocation()));
            }
            catch (BundleException bundleException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to uninstall ", bundle, " in order to install ", lpkgFile}), (Throwable)bundleException);
            }
        }
        try {
            String location = LPKGLocationUtil.getLPKGLocation(lpkgFile);
            Bundle lpkgBundle = bundleContext.getBundle(location);
            if (lpkgBundle != null) {
                return Collections.emptyList();
            }
            this._deployLicense(lpkgFile);
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            lpkgBundle = bundleContext.installBundle(location, this.toBundle(lpkgFile));
            if (lpkgBundle.getState() == 1) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skipped deployment of outdated LPKG " + lpkgFile));
                }
                return bundles;
            }
            BundleStartLevel bundleStartLevel = (BundleStartLevel)lpkgBundle.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
            bundles.add(lpkgBundle);
            List newBundles = (List)this._lpkgBundleTracker.getObject(lpkgBundle);
            if (newBundles != null) {
                bundles.addAll(newBundles);
            }
            if (!oldBundles.isEmpty()) {
                FrameworkEvent frameworkEvent;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Start refreshing references to point to the new bundle " + lpkgBundle));
                }
                if ((frameworkEvent = this._refreshBundles(null, bundleContext)).getType() == 4) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Finished refreshing references to point to the new bundle " + lpkgBundle));
                    }
                } else {
                    throw new Exception(StringBundler.concat((Object[])new Object[]{"Unable to refresh references to the new bundle ", lpkgBundle, " because of framework event ", frameworkEvent}), frameworkEvent.getThrowable());
                }
            }
            return bundles;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public Map<Bundle, List<Bundle>> getDeployedLPKGBundles() {
        return this._lpkgBundleTracker.getTracked();
    }

    public InputStream toBundle(File lpkgFile) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream((int)(lpkgFile.length() + 512L));){
            try (ZipFile zipFile = new ZipFile(lpkgFile);
                 JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                String name = lpkgFile.getName();
                this._writeManifest(zipFile, jarOutputStream, name.substring(0, name.length() - 5));
                ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
                jarOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                StreamUtil.transfer((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)jarOutputStream, (boolean)false);
                jarOutputStream.closeEntry();
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        try {
            this._activate(bundleContext);
        }
        catch (Throwable throwable) {
            this._throwableCollector.collect(throwable);
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this._lpkgBundleTracker.close();
        this._wabBundleTracker.close();
    }

    private void _activate(BundleContext bundleContext) throws Exception {
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new LPKGURLStreamHandlerService(this._urls), (Dictionary)HashMapDictionaryBuilder.put((Object)"url.handler.protocol", (Object)new String[]{"lpkg"}).build());
        this._wabBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)new WABWrapperBundleTrackerCustomizer(bundleContext));
        this._wabBundleTracker.open();
        HashSet<Bundle> removalPendingBundles = new HashSet<Bundle>();
        this._deploymentDirPath = this._getDeploymentDirPath();
        Path overrideDirPath = this._deploymentDirPath.resolve("override");
        List<File> jarFiles = this._scanFiles(overrideDirPath, ".jar", true, false);
        removalPendingBundles.addAll(this._uninstallOrphanOverridingJars(bundleContext, jarFiles));
        List<File> warFiles = this._scanFiles(overrideDirPath, ".war", true, false);
        this._uninstallOrphanOverridingWars(bundleContext, warFiles);
        if (!removalPendingBundles.isEmpty()) {
            FrameworkEvent frameworkEvent;
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Start refreshing uninstalled orphan bundles");
            }
            if ((frameworkEvent = this._refreshBundles(removalPendingBundles, bundleContext)).getType() == 4) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Finished refreshing uninstalled orphan bundles");
                }
            } else {
                throw new Exception("Unable to refresh uninstalled orphan bundles because of framework event " + frameworkEvent, frameworkEvent.getThrowable());
            }
        }
        LPKGBundleTrackerCustomizer lpkgBundleTrackerCustomizer = new LPKGBundleTrackerCustomizer(bundleContext, this._urls, this._toFileNames(jarFiles, warFiles));
        this._lpkgBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)lpkgBundleTrackerCustomizer);
        this._lpkgBundleTracker.open();
        lpkgBundleTrackerCustomizer.cleanTrackedBundles(this._lpkgBundleTracker.getBundles());
        List<File> lpkgFiles = this._scanFiles(this._deploymentDirPath, ".lpkg", false, true);
        if (lpkgFiles.isEmpty()) {
            return;
        }
        ArrayList<File> explodedLPKGFiles = new ArrayList<File>();
        Iterator<File> iterator = lpkgFiles.iterator();
        while (iterator.hasNext()) {
            File lpkgFile = iterator.next();
            List<File> innerLPKGFiles = ContainerLPKGUtil.deploy(lpkgFile, null);
            if (innerLPKGFiles == null) continue;
            iterator.remove();
            explodedLPKGFiles.addAll(innerLPKGFiles);
        }
        lpkgFiles.addAll(explodedLPKGFiles);
        this._installLPKGs(bundleContext, lpkgFiles);
        this._installOverrideJars(bundleContext, jarFiles);
        this._installOverrideWars(bundleContext, warFiles);
    }

    private void _deployLicense(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!zipEntryName.endsWith(".xml")) continue;
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        String content = StreamUtil.toString((InputStream)inputStream);
                        Document document = SAXReaderUtil.read((String)content);
                        Element rootElement = document.getRootElement();
                        String rootElementName = rootElement.getName();
                        if (!rootElementName.equals("license") && !rootElementName.equals("licenses")) continue;
                        JSONObject jsonObject = JSONUtil.put((String)"licenseXML", (Object)content);
                        LicenseManagerUtil.registerLicense((JSONObject)jsonObject);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to register license", (Throwable)exception);
        }
    }

    private Path _getDeploymentDirPath() throws Exception {
        File deploymentDir = new File(PropsValues.MODULE_FRAMEWORK_MARKETPLACE_DIR);
        deploymentDir = deploymentDir.getCanonicalFile();
        deploymentDir.mkdirs();
        return deploymentDir.toPath();
    }

    private void _installLPKGs(BundleContext bundleContext, List<File> lpkgFiles) {
        for (File lpkgFile : lpkgFiles) {
            try {
                List<Bundle> bundles = this.deploy(bundleContext, lpkgFile);
                if (bundles.isEmpty()) continue;
                Bundle lpkgBundle = bundles.get(0);
                lpkgBundle.start();
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to deploy LPKG file " + lpkgFile), (Throwable)exception);
            }
        }
    }

    private void _installOverrideJars(BundleContext bundleContext, List<File> jarFiles) throws Exception {
        for (File jarFile : jarFiles) {
            String location = _LPKG_OVERRIDE_PREFIX.concat(jarFile.getCanonicalPath());
            Bundle jarBundle = bundleContext.getBundle(location);
            if (jarBundle != null) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Using overriding JAR bundle " + location));
                continue;
            }
            jarBundle = bundleContext.installBundle(location, (InputStream)new FileInputStream(jarFile));
            BundleStartLevelUtil.setStartLevelAndStart((Bundle)jarBundle, (int)ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, (BundleContext)bundleContext);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Installed override JAR bundle " + location));
        }
    }

    private void _installOverrideWars(BundleContext bundleContext, List<File> warFiles) throws Exception {
        Properties properties = this._loadOverrideWarsProperties(bundleContext);
        Path osgiWarDir = Paths.get(PropsValues.MODULE_FRAMEWORK_WAR_DIR, new String[0]);
        boolean modified = false;
        for (File warFile : warFiles) {
            String sourceLocation = warFile.getCanonicalPath();
            String targetLocation = properties.getProperty(sourceLocation);
            if (targetLocation != null) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Using overridding WAR bundle " + targetLocation));
                continue;
            }
            Path sourceWarPath = warFile.toPath();
            Path targetWarPath = osgiWarDir.resolve(sourceWarPath.getFileName());
            Files.copy(sourceWarPath, targetWarPath, StandardCopyOption.REPLACE_EXISTING);
            targetLocation = targetWarPath.toString();
            properties.put(sourceLocation, targetLocation);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deployed override WAR bundle to " + targetLocation));
            }
            modified = true;
        }
        if (modified) {
            this._saveOverrideWarsProperties(bundleContext, properties);
        }
    }

    private boolean _isValid(String pathName) {
        int index = pathName.lastIndexOf(45);
        if (index == -1) {
            return true;
        }
        String version = pathName.substring(index + 1, pathName.length() - 4);
        int count = StringUtil.count((String)version, (char)'.');
        return count != 2 && count != 3;
    }

    private Properties _loadOverrideWarsProperties(BundleContext bundleContext) throws Exception {
        Bundle bundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = bundle.getBundleContext();
        File overrideWarsPropertiesFile = systemBundleContext.getDataFile("override-wars.properties");
        Properties overrideWarsProperties = new Properties();
        if (overrideWarsPropertiesFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(overrideWarsPropertiesFile);){
                overrideWarsProperties.load(inputStream);
            }
        }
        return overrideWarsProperties;
    }

    private FrameworkEvent _refreshBundles(Collection<Bundle> bundles, BundleContext bundleContext) throws Exception {
        Bundle systemBundle = bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        return (FrameworkEvent)defaultNoticeableFuture.get();
    }

    private void _saveOverrideWarsProperties(BundleContext bundleContext, Properties properties) throws Exception {
        Bundle bundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = bundle.getBundleContext();
        File overrideWarsPropertiesFile = systemBundleContext.getDataFile("override-wars.properties");
        try (FileOutputStream outputStream = new FileOutputStream(overrideWarsPropertiesFile);){
            properties.store(outputStream, null);
        }
    }

    private List<File> _scanFiles(Path dirPath, String extension, boolean checkFileName, boolean recursive) throws IOException {
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);){
            for (Path path : directoryStream) {
                String pathName = StringUtil.toLowerCase((String)String.valueOf(path.getFileName()));
                if (!pathName.endsWith(extension)) {
                    if (!recursive || !Files.isDirectory(path, new LinkOption[0])) continue;
                    files.addAll(this._scanFiles(path, extension, checkFileName, recursive));
                    continue;
                }
                if (checkFileName && !this._isValid(pathName)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Override file " + path + " has an invalid name and will be ignored"));
                    continue;
                }
                files.add(path.toFile());
            }
        }
        return files;
    }

    private Set<String> _toFileNames(List<File> jarFiles, List<File> warFiles) {
        HashSet<String> fileNames = new HashSet<String>();
        for (File file : jarFiles) {
            fileNames.add(StringUtil.toLowerCase((String)file.getName()));
        }
        for (File file : warFiles) {
            fileNames.add(StringUtil.toLowerCase((String)file.getName()));
        }
        return fileNames;
    }

    private Set<Bundle> _uninstallOrphanOverridingJars(BundleContext bundleContext, List<File> jarFiles) throws Exception {
        HashSet<Bundle> removedBundles = new HashSet<Bundle>();
        for (Bundle bundle : bundleContext.getBundles()) {
            String filePath;
            String location = bundle.getLocation();
            if (!location.startsWith(_LPKG_OVERRIDE_PREFIX) || jarFiles.contains(new File(filePath = location.substring(_LPKG_OVERRIDE_PREFIX.length())))) continue;
            bundle.uninstall();
            removedBundles.add(bundle);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Uninstalled orphan overriding JAR bundle " + location));
        }
        return removedBundles;
    }

    private void _uninstallOrphanOverridingWars(BundleContext bundleContext, List<File> warFiles) throws Exception {
        Properties properties = this._loadOverrideWarsProperties(bundleContext);
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entrySet.iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (warFiles.contains(new File((String)entry.getKey()))) continue;
            iterator.remove();
            Files.deleteIfExists(Paths.get((String)entry.getValue(), new String[0]));
            modified = true;
        }
        if (modified) {
            this._saveOverrideWarsProperties(bundleContext, properties);
        }
    }

    private void _writeManifest(ZipFile zipFile, JarOutputStream jarOutputStream, String symbolicName) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipFile.getEntry("liferay-marketplace.properties")));
        attributes.putValue("Bundle-Description", properties.getProperty("description"));
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", symbolicName);
        attributes.putValue("Bundle-Version", properties.getProperty("version"));
        attributes.putValue("Liferay-Releng-Bundle-Type", "lpkg");
        attributes.putValue("Manifest-Version", "2");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

