/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.lpkg.StaticLPKGResolver;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ModuleFrameworkPropsValues;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.internal.LPKGBatchInstallThreadLocal;
import com.liferay.portal.lpkg.deployer.internal.LPKGLocationUtil;
import com.liferay.portal.lpkg.deployer.internal.WABWrapperUtil;
import com.liferay.portal.lpkg.deployer.internal.osgi.util.tracker.URLStreamHandlerServiceServiceTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.wrapper.bundle.activator.WARBundleWrapperBundleActivator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.url.URLConstants;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LPKGBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<Bundle>> {
    private static final String _FILE_NAME_LFR_OUTDATED = ".lfr-outdated";
    private static final String _FILE_NAME_LPKG_DATA = "lpkg.data.file";
    private static final Log _log = LogFactoryUtil.getLog(LPKGBundleTrackerCustomizer.class);
    private static final Pattern _pattern = Pattern.compile("([a-zA-Z0-9_\\-\\.]+?)-\\d+[\\.\\d+]?[\\.\\d+]?(\\.[a-zA-Z0-9_-]+)*(\\..+)");
    private static final List<String> _staticLPKGBundleSymbolicNames = StaticLPKGResolver.getStaticLPKGBundleSymbolicNames();
    private final BundleContext _bundleContext;
    private final File _dataFile;
    private final Set<String> _outdatedRemoteAppIds = new HashSet<String>();
    private final Set<String> _overrideFileNames;
    private final Properties _properties = new Properties();
    private final Map<String, URL> _urls;

    public LPKGBundleTrackerCustomizer(BundleContext bundleContext, Map<String, URL> urls, Set<String> overrideFileNames) {
        this._bundleContext = bundleContext;
        this._urls = urls;
        this._overrideFileNames = overrideFileNames;
        Bundle bundle = bundleContext.getBundle();
        this._dataFile = bundle.getDataFile(_FILE_NAME_LPKG_DATA);
        if (this._dataFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(this._dataFile);){
                this._properties.load(inputStream);
            }
            catch (IOException ioException) {
                _log.error((Object)"Unable to load tracked bundles", (Throwable)ioException);
            }
        }
    }

    public List<Bundle> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (bundle.getEntry(_FILE_NAME_LFR_OUTDATED) != null) {
            try {
                bundle.uninstall();
            }
            catch (BundleException bundleException) {
                _log.error((Object)("Unable to uninstall LPKG " + bundle), (Throwable)bundleException);
            }
            return null;
        }
        try {
            Properties properties = this._readMarketplaceProperties(bundle);
            if (properties == null) {
                return null;
            }
            if (this._outdatedRemoteAppIds.contains(properties.getProperty("remote-app-id"))) {
                this._processOutdatedBundle(bundle);
                return null;
            }
            String supersedesRemoteAppIds = properties.getProperty("supersedes-remote-app-ids");
            if (supersedesRemoteAppIds != null) {
                Collections.addAll(this._outdatedRemoteAppIds, StringUtil.split((String)supersedesRemoteAppIds, (char)','));
                for (Bundle installedBundle : this._bundleContext.getBundles()) {
                    properties = this._readMarketplaceProperties(installedBundle);
                    if (properties == null || !this._outdatedRemoteAppIds.contains(properties.getProperty("remote-app-id"))) continue;
                    this._processOutdatedBundle(installedBundle);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to determine if LPKG " + bundle + " is outdated"), (Throwable)exception);
        }
        String symbolicName = bundle.getSymbolicName();
        if (_staticLPKGBundleSymbolicNames.contains(symbolicName)) {
            return Collections.emptyList();
        }
        File file = null;
        try {
            URI uri = new URI(bundle.getLocation());
            uri = uri.normalize();
            file = new File(uri.getPath());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalArgumentException("Unable to parse LPKG location " + bundle.getLocation(), uriSyntaxException);
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        try (ZipFile zipFile = new ZipFile(file);){
            ArrayList<Bundle> installedBundles = new ArrayList<Bundle>();
            ArrayList<String> innerBundleLocations = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Bundle newBundle;
                block51: {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String name = zipEntry.getName();
                    if (!name.endsWith(".jar") && !name.endsWith(".war")) continue;
                    String location = LPKGLocationUtil.generateInnerBundleLocation(bundle, name);
                    innerBundleLocations.add(location);
                    StringBundler sb = new StringBundler(4);
                    sb.append("jar:");
                    URI uri = file.toURI();
                    sb.append(URLCodec.decodeURL((String)uri.toString()));
                    sb.append("!/");
                    sb.append(name);
                    URL url = new URL(sb.toString());
                    if (this._isOverridden(symbolicName, name, location)) continue;
                    String liferayEnterpriseApp = null;
                    String lpkgURL = null;
                    String servletContextName = null;
                    if (name.endsWith(".war")) {
                        sb = new StringBundler(10);
                        sb.append("lpkg:/");
                        sb.append(URLCodec.encodeURL((String)bundle.getSymbolicName()));
                        sb.append("-");
                        sb.append((Object)bundle.getVersion());
                        sb.append("/");
                        Properties liferayPluginPackageProperties = this._readLiferayPluginPackageProperties(url);
                        liferayEnterpriseApp = liferayPluginPackageProperties.getProperty("Liferay-Enterprise-App");
                        servletContextName = liferayPluginPackageProperties.getProperty("servlet-context-name");
                        sb.append(servletContextName);
                        sb.append(".war");
                        String portalProfileNames = liferayPluginPackageProperties.getProperty("liferay-portal-profile-names");
                        if (Validator.isNotNull((String)portalProfileNames)) {
                            sb.append("?liferay-portal-profile-names=");
                            sb.append(portalProfileNames);
                        }
                        lpkgURL = sb.toString();
                        this._urls.put(lpkgURL, url);
                    }
                    if ((newBundle = this._bundleContext.getBundle(location)) != null) {
                        bundles.add(newBundle);
                        continue;
                    }
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        if (name.endsWith("jar")) {
                            if (this._isBundleInstalled(bundle, url, location)) continue;
                            newBundle = this._bundleContext.installBundle(location, inputStream);
                            break block51;
                        }
                        if (!name.endsWith("war")) break block51;
                        newBundle = this._bundleContext.installBundle(location, this._toWARWrapperBundle(bundle, liferayEnterpriseApp, lpkgURL, servletContextName, url));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                if (newBundle.getState() == 1) continue;
                bundles.add(newBundle);
                installedBundles.add(newBundle);
            }
            if (!LPKGBatchInstallThreadLocal.isBatchInstallInProcess()) {
                for (Bundle installedBundle : installedBundles) {
                    Dictionary headers = installedBundle.getHeaders("");
                    String header = (String)headers.get("Web-ContextPath");
                    if (header != null) {
                        BundleStartLevelUtil.setStartLevelAndStart((Bundle)installedBundle, (int)ModuleFrameworkPropsValues.MODULE_FRAMEWORK_WEB_START_LEVEL, (BundleContext)this._bundleContext);
                        continue;
                    }
                    BundleStartLevelUtil.setStartLevelAndStart((Bundle)installedBundle, (int)ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, (BundleContext)this._bundleContext);
                }
            }
            List<String> trackedBundleLocations = this._reloadTrackedBundles(symbolicName, bundle, bundles);
            innerBundleLocations.sort(null);
            if (!trackedBundleLocations.equals(innerBundleLocations)) {
                this._recordTrackedBundles(bundle, innerBundleLocations);
            }
        }
        catch (Throwable throwable) {
            _log.error((Object)("Rollback bundle installation for " + bundles), throwable);
            for (Bundle newBundle : bundles) {
                try {
                    newBundle.uninstall();
                }
                catch (BundleException bundleException) {
                    _log.error((Object)("Unable to uninstall bundle " + newBundle), (Throwable)bundleException);
                }
            }
            return null;
        }
        return new ArrayList<Bundle>(bundles);
    }

    public void cleanTrackedBundles(Bundle[] bundles) throws IOException {
        if (bundles == null) {
            if (this._dataFile.exists()) {
                this._dataFile.delete();
            }
            return;
        }
        HashSet<String> propertyNames = new HashSet<String>(this._properties.stringPropertyNames());
        for (Bundle bundle : bundles) {
            propertyNames.remove(bundle.getSymbolicName());
        }
        if (!propertyNames.isEmpty()) {
            return;
        }
        for (String propertyName : propertyNames) {
            this._properties.remove(propertyName);
        }
        try (FileOutputStream outputStream = new FileOutputStream(this._dataFile);){
            this._properties.store(outputStream, null);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
        block11: {
            if (bundle.getState() != 4 || bundleEvent.getType() != 32) {
                return;
            }
            try {
                Object newBundles = this.addingBundle(bundle, bundleEvent);
                if (newBundles != null) {
                    bundles.removeAll((Collection<?>)newBundles);
                }
                for (Bundle bundle2 : bundles) {
                    if (bundle2.getState() == 1) continue;
                    bundle2.uninstall();
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Uninstalled ", bundle2, "because ", bundle, " was updated"}));
                }
                bundles.clear();
                if (newBundles != null) {
                    bundles.addAll((Collection<Bundle>)newBundles);
                }
                ArrayList<String> bundleLocations = new ArrayList<String>();
                for (Bundle installedBundle : bundles) {
                    Dictionary headers;
                    String fragmentHost;
                    if (installedBundle.getState() == 4 && (fragmentHost = (String)(headers = installedBundle.getHeaders("")).get("Fragment-Host")) == null) {
                        installedBundle.start();
                    }
                    bundleLocations.add(installedBundle.getLocation());
                }
                bundleLocations.sort(null);
                if (bundleLocations.equals(this._properties.getProperty(bundle.getSymbolicName()))) break block11;
                this._recordTrackedBundles(bundle, bundleLocations);
            }
            catch (Exception exception) {
                _log.error((Object)("Rollback bundle refresh for " + bundles), (Throwable)exception);
                for (Bundle bundle3 : bundles) {
                    try {
                        bundle3.uninstall();
                    }
                    catch (BundleException bundleException) {
                        _log.error((Object)("Unable to uninstall bundle " + bundle3), (Throwable)bundleException);
                    }
                }
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
        if (bundle.getState() != 1) {
            return;
        }
        String lpkgBundleSymbolicName = bundle.getSymbolicName();
        String prefix = lpkgBundleSymbolicName.concat("-");
        for (Bundle newBundle : bundles) {
            try {
                this._uninstallBundle(prefix, newBundle);
            }
            catch (Throwable throwable) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to uninstall ", newBundle, " in response to uninstallation of ", bundle}), throwable);
            }
        }
        this._properties.remove(bundle.getSymbolicName());
    }

    private String _buildImportPackageString(Class<?> ... classes) {
        StringBundler sb = new StringBundler(classes.length * 2);
        for (Class<?> clazz : classes) {
            Package pkg = clazz.getPackage();
            sb.append(pkg.getName());
            sb.append(",");
        }
        int index = sb.index();
        if (index > 0) {
            sb.setIndex(index - 1);
        }
        return sb.toString();
    }

    private String _extractFileName(String string) {
        Matcher matcher = _pattern.matcher(string);
        if (matcher.matches()) {
            String name = matcher.group(1);
            return name.concat(matcher.group(3));
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to extract symbolic name from " + string));
        }
        return "";
    }

    private boolean _isBundleInstalled(Bundle bundle, URL url, String location) throws IOException {
        try (InputStream inputStream = url.openStream();
             JarInputStream jarInputStream = new JarInputStream(inputStream);){
            Manifest manifest = jarInputStream.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String symbolicName = attributes.getValue("Bundle-SymbolicName");
            Version version = new Version(attributes.getValue("Bundle-Version"));
            for (Bundle installedBundle : this._bundleContext.getBundles()) {
                if (!symbolicName.equals(installedBundle.getSymbolicName()) || !version.equals((Object)installedBundle.getVersion()) || location.equals(installedBundle.getLocation())) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Skipping installation of ", symbolicName, " with version ", version, " in ", bundle.getSymbolicName(), " because an identical bundle exists"}));
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean _isOverridden(String symbolicName, String name, String location) throws Throwable {
        if (this._overrideFileNames.isEmpty()) {
            return false;
        }
        name = this._extractFileName(name);
        if (this._overrideFileNames.contains(name = StringUtil.toLowerCase((String)name))) {
            Bundle bundle = this._bundleContext.getBundle(location);
            if (bundle != null) {
                this._uninstallBundle(symbolicName.concat("-"), bundle);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Disabled ", symbolicName, ":", name}));
                }
            }
            return true;
        }
        return false;
    }

    private void _processOutdatedBundle(Bundle bundle) throws Exception {
        Path path = Paths.get(bundle.getLocation(), new String[0]);
        try (FileSystem fileSystem = FileSystems.newFileSystem(path, (ClassLoader)null);){
            Files.createFile(fileSystem.getPath(_FILE_NAME_LFR_OUTDATED, new String[0]), new FileAttribute[0]);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Uninstalling outdated bundle " + bundle));
        }
        bundle.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties _readLiferayPluginPackageProperties(URL url) throws IOException {
        String pathString = url.getPath();
        String servletContextName = pathString.substring(pathString.lastIndexOf(47) + 1, pathString.lastIndexOf(".war"));
        int index = servletContextName.lastIndexOf(45);
        if (index >= 0) {
            servletContextName = servletContextName.substring(0, index);
        }
        Properties properties = new Properties();
        Path tempFilePath = Files.createTempFile(null, null, new FileAttribute[0]);
        try (InputStream inputStream1 = url.openStream();){
            Files.copy(inputStream1, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
            try (ZipFile zipFile = new ZipFile(tempFilePath.toFile());
                 InputStream inputStream2 = zipFile.getInputStream(new ZipEntry("WEB-INF/liferay-plugin-package.properties"));){
                if (inputStream2 != null) {
                    properties.load(inputStream2);
                    String configuredServletContextName = properties.getProperty("servlet-context-name");
                    if (configuredServletContextName == null) {
                        properties.put("servlet-context-name", servletContextName);
                    }
                }
            }
        }
        finally {
            Files.delete(tempFilePath);
        }
        return properties;
    }

    private Properties _readMarketplaceProperties(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("liferay-marketplace.properties");
        if (url == null) {
            return null;
        }
        return PropertiesUtil.load((URL)url);
    }

    private void _recordTrackedBundles(Bundle bundle, List<String> innerBundleLocations) throws IOException {
        this._properties.setProperty(bundle.getSymbolicName(), StringUtil.merge(innerBundleLocations));
        try (FileOutputStream outputStream = new FileOutputStream(this._dataFile);){
            this._properties.store(outputStream, null);
        }
    }

    private List<String> _reloadTrackedBundles(String lpkgSymbolicName, Bundle bundle, Set<Bundle> trackedBundles) {
        String[] locations;
        String storedBundles = this._properties.getProperty(bundle.getSymbolicName());
        if (storedBundles == null) {
            return Collections.emptyList();
        }
        for (String location : locations = StringUtil.split((String)storedBundles)) {
            Bundle installedBundle = this._bundleContext.getBundle(location);
            if (installedBundle == null || installedBundle.getState() == 1) continue;
            String name = location.substring(0, location.indexOf("?"));
            try {
                if (this._isOverridden(lpkgSymbolicName, name, location)) continue;
                trackedBundles.add(installedBundle);
            }
            catch (Throwable throwable) {
                _log.error((Object)("Unable to uninstall LPKG " + bundle), throwable);
                return Collections.emptyList();
            }
        }
        return Arrays.asList(locations);
    }

    private InputStream _toWARWrapperBundle(Bundle bundle, String liferayEnterpriseApp, String lpkgURL, String servletContextName, URL url) throws IOException {
        String pathString = url.getPath();
        String fileName = pathString.substring(pathString.lastIndexOf(47) + 1, pathString.lastIndexOf(".war"));
        String version = String.valueOf(bundle.getVersion());
        int index = fileName.lastIndexOf(45);
        if (index >= 0) {
            version = fileName.substring(index + 1);
        }
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                this._writeManifest(bundle, jarOutputStream, liferayEnterpriseApp, lpkgURL, servletContextName, version);
                this._writeClasses(jarOutputStream, BundleStartLevelUtil.class, WABWrapperUtil.class, WARBundleWrapperBundleActivator.class, URLStreamHandlerServiceServiceTrackerCustomizer.class);
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    private void _uninstallBundle(String prefix, Bundle bundle) throws Throwable {
        if (bundle.getState() == 1) {
            return;
        }
        String symbolicName = bundle.getSymbolicName();
        HashSet<Bundle> uninstalledBundles = new HashSet<Bundle>();
        Dictionary headers = bundle.getHeaders("");
        if (symbolicName.startsWith(prefix) && Boolean.valueOf((String)headers.get("Wrapper-Bundle")).booleanValue()) {
            String wrappedBundleSymbolicName = symbolicName.substring(prefix.length(), symbolicName.length() - 8);
            Version version = bundle.getVersion();
            for (Bundle curBundle : this._bundleContext.getBundles()) {
                if (!wrappedBundleSymbolicName.equals(curBundle.getSymbolicName()) || !version.equals((Object)curBundle.getVersion())) continue;
                curBundle.uninstall();
                uninstalledBundles.add(curBundle);
            }
        }
        bundle.uninstall();
        uninstalledBundles.add(bundle);
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(uninstalledBundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        FrameworkEvent frameworkEvent = (FrameworkEvent)defaultNoticeableFuture.get();
        if (frameworkEvent.getType() != 4) {
            throw frameworkEvent.getThrowable();
        }
    }

    private void _writeClasses(JarOutputStream jarOutputStream, Class<?> ... classes) throws IOException {
        for (Class<?> clazz : classes) {
            String className = clazz.getName();
            String path = StringUtil.replace((String)className, (char)'.', (char)'/');
            String resourcePath = path.concat(".class");
            jarOutputStream.putNextEntry(new ZipEntry(resourcePath));
            ClassLoader classLoader = clazz.getClassLoader();
            StreamUtil.transfer((InputStream)classLoader.getResourceAsStream(resourcePath), (OutputStream)jarOutputStream, (boolean)false);
            jarOutputStream.closeEntry();
        }
    }

    private void _writeManifest(Bundle bundle, JarOutputStream jarOutputStream, String liferayEnterpriseApp, String lpkgURL, String servletContextName, String version) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Bundle-Activator", WARBundleWrapperBundleActivator.class.getName());
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", StringBundler.concat((String[])new String[]{bundle.getSymbolicName(), "-", servletContextName, "-wrapper"}));
        attributes.putValue("Bundle-Version", version);
        attributes.putValue("Import-Package", this._buildImportPackageString(BundleActivator.class, BundleStartLevel.class, GetterUtil.class, ServiceTrackerCustomizer.class, StringBundler.class, URLConstants.class));
        if (liferayEnterpriseApp != null) {
            attributes.putValue("Liferay-Enterprise-App", liferayEnterpriseApp);
        }
        attributes.putValue("Liferay-WAB-Context-Name", servletContextName);
        attributes.putValue("Liferay-WAB-LPKG-URL", lpkgURL);
        attributes.putValue("Liferay-WAB-Start-Level", String.valueOf(ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL));
        attributes.putValue("Manifest-Version", "2");
        attributes.putValue("Wrapper-Bundle", "true");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

