/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.lpkg.deployer.internal.ContainerLPKGUtil;
import com.liferay.portal.lpkg.deployer.internal.LPKGBatchInstallThreadLocal;
import com.liferay.portal.lpkg.deployer.internal.LPKGLocationUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true, service={FileInstaller.class})
public class LPKGArtifactInstaller
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(LPKGArtifactInstaller.class);
    private BundleContext _bundleContext;
    @Reference
    private LPKGDeployer _lpkgDeployer;
    @Reference(target="(url.handler.protocol=webbundle)")
    private URLStreamHandlerService _urlStreamHandlerService;

    public boolean canTransformURL(File file) {
        String name = StringUtil.toLowerCase((String)file.getName());
        return name.endsWith(".lpkg");
    }

    public URL transformURL(File file) throws Exception {
        String canonicalPath = LPKGLocationUtil.getLPKGLocation(file);
        Bundle bundle = this._bundleContext.getBundle(canonicalPath);
        if (bundle != null) {
            this._update(file, this._readMarketplaceProperties(file));
            return null;
        }
        Properties properties = new Properties();
        List<File> lpkgFiles = ContainerLPKGUtil.deploy(file, this._bundleContext, properties);
        if (lpkgFiles == null) {
            this._install(file, properties);
            return null;
        }
        try (SafeCloseable safeCloseable = LPKGBatchInstallThreadLocal.setBatchInstallInProcess(true);){
            this._batchInstall(lpkgFiles);
        }
        return null;
    }

    public void uninstall(File file) throws Exception {
        Bundle bundle = this._bundleContext.getBundle(LPKGLocationUtil.getLPKGLocation(file));
        if (bundle != null) {
            bundle.uninstall();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private void _batchInstall(List<File> lpkgFiles) throws Exception {
        HashMap<Bundle, List<Bundle>> lpkgBundles = new HashMap<Bundle, List<Bundle>>();
        for (File file : lpkgFiles) {
            List<Bundle> bundles;
            Properties properties;
            block30: {
                properties = new Properties();
                try (ZipFile zipFile = new ZipFile(file);){
                    ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
                    if (zipEntry == null) break block30;
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        properties.load(inputStream);
                    }
                }
            }
            if ((bundles = this._install(file, properties)).isEmpty()) continue;
            lpkgBundles.put(bundles.remove(0), bundles);
        }
        block21: for (Map.Entry entry : lpkgBundles.entrySet()) {
            List bundles = (List)entry.getValue();
            for (Bundle bundle : bundles) {
                Dictionary headers = bundle.getHeaders("");
                String header = (String)headers.get("Web-ContextPath");
                try {
                    if (header == null) {
                        BundleStartLevelUtil.setStartLevelAndStart((Bundle)bundle, (int)PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, (BundleContext)this._bundleContext);
                        continue;
                    }
                    BundleStartLevelUtil.setStartLevelAndStart((Bundle)bundle, (int)PropsValues.MODULE_FRAMEWORK_WEB_START_LEVEL, (BundleContext)this._bundleContext);
                }
                catch (BundleException bundleException) {
                    _log.error((Object)("Rollback bundle installation for " + bundles), (Throwable)bundleException);
                    Bundle lpkgBundle = (Bundle)entry.getKey();
                    lpkgBundle.uninstall();
                    continue block21;
                }
            }
        }
    }

    private List<Bundle> _install(File file, Properties properties) throws Exception {
        String canonicalPath = LPKGLocationUtil.getLPKGLocation(file);
        Bundle existingBundle = this._bundleContext.getBundle(canonicalPath);
        if (existingBundle != null) {
            this._update(file, properties);
            return Collections.emptyList();
        }
        if (GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true)) {
            if (existingBundle == null) {
                this._logRestartRequired(canonicalPath);
            }
            return Collections.emptyList();
        }
        List bundles = this._lpkgDeployer.deploy(this._bundleContext, file);
        if (bundles.isEmpty()) {
            return Collections.emptyList();
        }
        Bundle lpkgBundle = (Bundle)bundles.get(0);
        try {
            lpkgBundle.start();
        }
        catch (BundleException bundleException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to start ", lpkgBundle, " for ", file}), (Throwable)bundleException);
        }
        return bundles;
    }

    private void _logRestartRequired(String canonicalPath) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("The portal instance needs to be restarted to complete the installation of " + canonicalPath));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties _readMarketplaceProperties(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties3.load(inputStream);
            }
            Properties properties = properties3;
            return properties;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return null;
            _log.debug((Object)("Unable to read liferay-marketplace.properties from " + file.getName()), (Throwable)exception);
            return null;
        }
    }

    private FrameworkEvent _refreshBundles(Set<Bundle> bundles) throws Exception {
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        return (FrameworkEvent)defaultNoticeableFuture.get();
    }

    private void _update(File file, Properties properties) throws Exception {
        String canonicalPath = LPKGLocationUtil.getLPKGLocation(file);
        Bundle bundle = this._bundleContext.getBundle(canonicalPath);
        if (bundle == null) {
            return;
        }
        Version currentVersion = bundle.getVersion();
        Version newVersion = new Version(properties.getProperty("version"));
        if (newVersion.compareTo(currentVersion) <= 0) {
            return;
        }
        if (GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true)) {
            this._logRestartRequired(canonicalPath);
            return;
        }
        Map deployedLPKGBundles = this._lpkgDeployer.getDeployedLPKGBundles();
        List installedBundles = (List)deployedLPKGBundles.get(bundle);
        HashSet<Bundle> wrapperBundles = new HashSet<Bundle>();
        for (Bundle installedBundle : installedBundles) {
            Dictionary headers = bundle.getHeaders("");
            if (!Boolean.getBoolean((String)headers.get("Wrapper-Bundle"))) continue;
            wrapperBundles.add(installedBundle);
        }
        if (!wrapperBundles.isEmpty()) {
            FrameworkEvent frameworkEvent;
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Refreshing ", wrapperBundles, " to update ", bundle}));
            }
            if ((frameworkEvent = this._refreshBundles(wrapperBundles)).getType() != 4) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to refresh ", wrapperBundles, " because of framework event ", frameworkEvent}), frameworkEvent.getThrowable());
            }
        }
        bundle.update(this._lpkgDeployer.toBundle(file));
    }
}

