/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.lpkg.deployer.internal.WABWrapperUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class WABWrapperBundleTrackerCustomizer
implements BundleTrackerCustomizer<Bundle> {
    private static final Log _log = LogFactoryUtil.getLog(WABWrapperBundleTrackerCustomizer.class);
    private final BundleContext _bundleContext;

    public WABWrapperBundleTrackerCustomizer(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        Dictionary headers = bundle.getHeaders("");
        if (Boolean.valueOf((String)headers.get("Wrapper-Bundle")).booleanValue()) {
            return bundle;
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle object) {
        if (bundle.getState() == 4 && bundleEvent.getType() == 32) {
            try {
                Bundle wabBundle = this._getWABBundle(bundle);
                if (wabBundle != null) {
                    wabBundle.start();
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to refresh " + bundle), (Throwable)exception);
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        block4: {
            if (bundle.getState() == 1) {
                try {
                    Bundle wabBundle = this._getWABBundle(bundle);
                    if (wabBundle != null) {
                        wabBundle.uninstall();
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
        }
    }

    private Bundle _getWABBundle(Bundle bundle) throws MalformedURLException {
        Dictionary headers = bundle.getHeaders("");
        URL lpkgURL = new URL((String)headers.get("Liferay-WAB-LPKG-URL"));
        String wabLocation = WABWrapperUtil.generateWABLocation(lpkgURL, bundle.getVersion(), (String)headers.get("Liferay-WAB-Context-Name"));
        return this._bundleContext.getBundle(wabLocation);
    }
}

