/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.jmx;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.messaging.internal.jmx.DestinationStatisticsManagerMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class DestinationStatisticsManager
extends StandardMBean
implements DestinationStatisticsManagerMBean {
    private static final String _OBJECT_NAME_CACHE_KEY_PREFIX = "MessagingDestinationStatistics-";
    private static final String _OBJECT_NAME_PREFIX = "com.liferay.portal.messaging:classification=messaging_destination,name=MessagingDestinationStatistics-";
    private boolean _autoRefresh;
    private final Destination _destination;
    private DestinationStatistics _destinationStatistics;
    private long _lastRefresh;

    public DestinationStatisticsManager(Destination destination) throws NotCompliantMBeanException {
        super(DestinationStatisticsManagerMBean.class);
        this._destination = destination;
    }

    @Override
    public int getActiveThreadCount() {
        if (this._autoRefresh) {
            this.refresh();
        }
        return this._destinationStatistics.getActiveThreadCount();
    }

    @Override
    public int getCurrentThreadCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getCurrentThreadCount();
    }

    @Override
    public int getLargestThreadCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getLargestThreadCount();
    }

    @Override
    public String getLastRefresh() {
        return String.valueOf(this._lastRefresh);
    }

    @Override
    public int getMaxThreadPoolSize() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getMaxThreadPoolSize();
    }

    @Override
    public int getMinThreadPoolSize() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getMinThreadPoolSize();
    }

    public String getObjectName() {
        return _OBJECT_NAME_PREFIX + this._destination.getName();
    }

    public String getObjectNameCacheKey() {
        return _OBJECT_NAME_CACHE_KEY_PREFIX + this._destination.getName();
    }

    @Override
    public long getPendingMessageCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getPendingMessageCount();
    }

    @Override
    public long getSentMessageCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        return this._destinationStatistics.getSentMessageCount();
    }

    @Override
    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    @Override
    public void refresh() {
        if (System.currentTimeMillis() > this._lastRefresh) {
            this._lastRefresh = System.currentTimeMillis();
            this._destinationStatistics = this._destination.getDestinationStatistics();
        }
    }

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        this._autoRefresh = autoRefresh;
    }
}

