/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.sender;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.messaging.internal.SynchronousDestination;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"mode=DIRECT"}, service={SynchronousMessageSender.class})
public class DirectSynchronousMessageSender
implements SynchronousMessageSender {
    private static final Log _log = LogFactoryUtil.getLog(DirectSynchronousMessageSender.class);
    @Reference
    private MessageBus _messageBus;

    public Object send(String destinationName, Message message) throws MessageBusException {
        Destination destination = this._messageBus.getDestination(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Destination " + destinationName + " is not configured"));
            }
            return null;
        }
        if (destination instanceof SynchronousDestination) {
            destination.send(message);
        } else {
            Set messageListeners = destination.getMessageListeners();
            for (MessageListener messageListener : messageListeners) {
                try {
                    messageListener.receive(message);
                }
                catch (MessageListenerException messageListenerException) {
                    throw new MessageBusException((Throwable)messageListenerException);
                }
            }
        }
        return message.getResponse();
    }

    public Object send(String destinationName, Message message, long timeout) throws MessageBusException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)(DirectSynchronousMessageSender.class.getName() + " does not support timeout"));
        }
        return this.send(destinationName, message);
    }
}

