/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusEventListener;
import com.liferay.portal.kernel.messaging.MessageBusInterceptor;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.messaging.internal.BaseAsyncDestination;
import com.liferay.portal.messaging.internal.MessageBusThreadLocalUtil;
import com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={MessageBus.class})
public class DefaultMessageBus
implements MessageBus {
    private static final Log _log = LogFactoryUtil.getLog(DefaultMessageBus.class);
    private final Map<String, Destination> _destinations = new ConcurrentHashMap<String, Destination>();
    private final Map<String, DestinationWorkerConfiguration> _destinationWorkerConfigurations = new ConcurrentHashMap<String, DestinationWorkerConfiguration>();
    private final Map<String, String> _factoryPidsToDestinationNames = new ConcurrentHashMap<String, String>();
    private final Set<MessageBusEventListener> _messageBusEventListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private ServiceTracker<MessageListener, ObjectValuePair<String, MessageListener>> _messageListenerServiceTracker;
    private final Map<String, List<MessageListener>> _queuedMessageListeners = new HashMap<String, List<MessageListener>>();
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;
    private ServiceTrackerList<MessageBusInterceptor> _serviceTrackerList;

    public Destination getDestination(String destinationName) {
        return this._destinations.get(destinationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String destinationName, Message message) {
        Long[] companyIds;
        MessageBusThreadLocalUtil.populateMessageFromThreadLocals(message);
        for (MessageBusInterceptor messageBusInterceptor : this._serviceTrackerList) {
            if (!messageBusInterceptor.intercept((MessageBus)this, destinationName, message)) continue;
            return;
        }
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Destination " + destinationName + " is not configured"));
            }
            return;
        }
        message.setDestinationName(destinationName);
        if (message.get("companyId") == null && (companyIds = (Long[])message.get("companyIds")) != null) {
            long orignalCompanyId = CompanyThreadLocal.getCompanyId();
            try {
                for (Long id : companyIds) {
                    CompanyThreadLocal.setCompanyId((Long)id);
                    message.put("companyId", (Object)id);
                    destination.send(message.clone());
                }
            }
            finally {
                CompanyThreadLocal.setCompanyId((Long)orignalCompanyId);
            }
            return;
        }
        destination.send(message);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean force) {
        for (Destination destination : this._destinations.values()) {
            destination.close(force);
        }
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._messageListenerServiceTracker = new ServiceTracker(bundleContext, MessageListener.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MessageListener, ObjectValuePair<String, MessageListener>>(){

            public ObjectValuePair<String, MessageListener> addingService(ServiceReference<MessageListener> serviceReference) {
                String destinationName = (String)serviceReference.getProperty("destination.name");
                if (destinationName == null) {
                    return null;
                }
                MessageListener messageListener = (MessageListener)bundleContext.getService(serviceReference);
                DefaultMessageBus.this._registerMessageListener(destinationName, messageListener);
                return new ObjectValuePair((Object)destinationName, (Object)messageListener);
            }

            public void modifiedService(ServiceReference<MessageListener> serviceReference, ObjectValuePair<String, MessageListener> objectValuePair) {
                this.removedService(serviceReference, objectValuePair);
                ObjectValuePair<String, MessageListener> newObjectValuePair = this.addingService(serviceReference);
                objectValuePair.setKey(newObjectValuePair.getKey());
            }

            public void removedService(ServiceReference<MessageListener> serviceReference, ObjectValuePair<String, MessageListener> objectValuePair) {
                DefaultMessageBus.this._unregisterMessageListener((String)objectValuePair.getKey(), (MessageListener)objectValuePair.getValue());
                bundleContext.ungetService(serviceReference);
            }
        });
        this._messageListenerServiceTracker.open();
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new DefaultMessageBusManagedServiceFactory(), (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)"com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration").build());
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, MessageBusInterceptor.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceRegistration.unregister();
        this._messageListenerServiceTracker.close();
        this._messageBusEventListeners.clear();
        this.shutdown(true);
        for (Destination destination : this._destinations.values()) {
            destination.destroy();
        }
        this._destinations.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(destination.name=*)")
    protected synchronized void registerDestination(Destination destination, Map<String, Object> properties) {
        String destinationName = MapUtil.getString(properties, (String)"destination.name");
        this._addDestination(destination);
        DestinationWorkerConfiguration destinationWorkerConfiguration = this._destinationWorkerConfigurations.get(destinationName);
        this._updateDestination(destination, destinationWorkerConfiguration);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(destination.name=*)")
    protected synchronized void registerDestinationEventListener(DestinationEventListener destinationEventListener, Map<String, Object> properties) {
        String destinationName = MapUtil.getString(properties, (String)"destination.name");
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to unregister destination event listener for " + destinationName));
            }
            return;
        }
        destination.addDestinationEventListener(destinationEventListener);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void registerMessageBusEventListener(MessageBusEventListener messageBusEventListener) {
        this._messageBusEventListeners.add(messageBusEventListener);
    }

    protected synchronized void unregisterDestination(Destination destination, Map<String, Object> properties) {
        this._removeDestination(destination.getName());
    }

    protected synchronized void unregisterDestinationEventListener(DestinationEventListener destinationEventListener, Map<String, Object> properties) {
        String destinationName = MapUtil.getString(properties, (String)"destination.name");
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to unregister destination event listener for " + destinationName));
            }
            return;
        }
        destination.removeDestinationEventListener(destinationEventListener);
    }

    protected void unregisterMessageBusEventListener(MessageBusEventListener messageBusEventListener) {
        this._messageBusEventListeners.remove(messageBusEventListener);
    }

    private void _addDestination(Destination destination) {
        Destination oldDestination = this._destinations.get(destination.getName());
        if (oldDestination != null) {
            oldDestination.copyDestinationEventListeners(destination);
            oldDestination.copyMessageListeners(destination);
        } else {
            List<MessageListener> messageListeners = this._queuedMessageListeners.remove(destination.getName());
            if (ListUtil.isNotEmpty(messageListeners)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Registering ", messageListeners.size(), " queued message listeners for destination ", destination.getName()}));
                }
                for (MessageListener messageListener : messageListeners) {
                    destination.register(messageListener);
                }
            }
        }
        destination.open();
        this._destinations.put(destination.getName(), destination);
        if (oldDestination != null) {
            oldDestination.destroy();
            for (MessageBusEventListener messageBusEventListener : this._messageBusEventListeners) {
                messageBusEventListener.destinationRemoved(oldDestination);
            }
        }
        for (MessageBusEventListener messageBusEventListener : this._messageBusEventListeners) {
            messageBusEventListener.destinationAdded(destination);
        }
    }

    private synchronized boolean _registerMessageListener(String destinationName, MessageListener messageListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination != null) {
            return destination.register(messageListener);
        }
        List<MessageListener> queuedMessageListeners = this._queuedMessageListeners.get(destinationName);
        if (queuedMessageListeners == null) {
            queuedMessageListeners = new ArrayList<MessageListener>();
            this._queuedMessageListeners.put(destinationName, queuedMessageListeners);
        }
        queuedMessageListeners.add(messageListener);
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Queuing message listener until destination " + destinationName + " is added"));
        }
        return false;
    }

    private Destination _removeDestination(String destinationName) {
        Destination destination = this._destinations.remove(destinationName);
        if (destination == null) {
            return null;
        }
        destination.destroy();
        for (MessageBusEventListener messageBusEventListener : this._messageBusEventListeners) {
            messageBusEventListener.destinationRemoved(destination);
        }
        return destination;
    }

    private synchronized boolean _unregisterMessageListener(String destinationName, MessageListener messageListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination != null) {
            return destination.unregister(messageListener);
        }
        List<MessageListener> queuedMessageListeners = this._queuedMessageListeners.get(destinationName);
        if (ListUtil.isEmpty(queuedMessageListeners)) {
            return false;
        }
        return queuedMessageListeners.remove(messageListener);
    }

    private void _updateDestination(Destination destination, DestinationWorkerConfiguration destinationWorkerConfiguration) {
        if (destination == null || destinationWorkerConfiguration == null) {
            return;
        }
        if (destination instanceof BaseAsyncDestination) {
            BaseAsyncDestination baseAsyncDestination = (BaseAsyncDestination)destination;
            baseAsyncDestination.setMaximumQueueSize(destinationWorkerConfiguration.maxQueueSize());
            baseAsyncDestination.setWorkersSize(destinationWorkerConfiguration.workerCoreSize(), destinationWorkerConfiguration.workerMaxSize());
        }
    }

    private class DefaultMessageBusManagedServiceFactory
    implements ManagedServiceFactory {
        private DefaultMessageBusManagedServiceFactory() {
        }

        public void deleted(String factoryPid) {
            String destinationName = (String)DefaultMessageBus.this._factoryPidsToDestinationNames.remove(factoryPid);
            DefaultMessageBus.this._destinationWorkerConfigurations.remove(destinationName);
        }

        public String getName() {
            return "Default Message Bus";
        }

        public void updated(String factoryPid, Dictionary<String, ?> dictionary) throws ConfigurationException {
            DestinationWorkerConfiguration destinationWorkerConfiguration = (DestinationWorkerConfiguration)ConfigurableUtil.createConfigurable(DestinationWorkerConfiguration.class, dictionary);
            DefaultMessageBus.this._factoryPidsToDestinationNames.put(factoryPid, destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._destinationWorkerConfigurations.put(destinationWorkerConfiguration.destinationName(), destinationWorkerConfiguration);
            Destination destination = (Destination)DefaultMessageBus.this._destinations.get(destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._updateDestination(destination, destinationWorkerConfiguration);
        }
    }
}

