/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.messaging.internal.DestinationPrototype;
import com.liferay.portal.messaging.internal.SerialDestination;

public class SerialDestinationPrototype
implements DestinationPrototype {
    private static final int _WORKERS_CORE_SIZE = 1;
    private static final int _WORKERS_MAX_SIZE = 1;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final PortalExecutorManager _portalExecutorManager;
    private final UserLocalService _userLocalService;

    public SerialDestinationPrototype(PortalExecutorManager portalExecutorManager, PermissionCheckerFactory permissionCheckerFactory, UserLocalService userLocalService) {
        this._portalExecutorManager = portalExecutorManager;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._userLocalService = userLocalService;
    }

    @Override
    public Destination createDestination(DestinationConfiguration destinationConfiguration) {
        SerialDestination serialDestination = new SerialDestination();
        serialDestination.setDestinationType(destinationConfiguration.getDestinationType());
        serialDestination.setName(destinationConfiguration.getDestinationName());
        serialDestination.setMaximumQueueSize(destinationConfiguration.getMaximumQueueSize());
        serialDestination.setPermissionCheckerFactory(this._permissionCheckerFactory);
        serialDestination.setPortalExecutorManager(this._portalExecutorManager);
        serialDestination.setRejectedExecutionHandler(destinationConfiguration.getRejectedExecutionHandler());
        serialDestination.setUserLocalService(this._userLocalService);
        serialDestination.setWorkersSize(1, 1);
        return serialDestination;
    }
}

