/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusInterceptor;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.messaging.internal.BaseAsyncDestination;
import com.liferay.portal.messaging.internal.MessageBusThreadLocalUtil;
import com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={MessageBus.class})
public class DefaultMessageBus
implements MessageBus {
    private static final Log _log = LogFactoryUtil.getLog(DefaultMessageBus.class);
    private final Map<String, Destination> _destinations = new ConcurrentHashMap<String, Destination>();
    private final Map<String, DestinationWorkerConfiguration> _destinationWorkerConfigurations = new ConcurrentHashMap<String, DestinationWorkerConfiguration>();
    private final Map<String, String> _factoryPidsToDestinationNames = new ConcurrentHashMap<String, String>();
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;
    private ServiceTrackerList<MessageBusInterceptor> _serviceTrackerList;

    public Destination getDestination(String destinationName) {
        return this._destinations.get(destinationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String destinationName, Message message) {
        Long[] companyIds;
        MessageBusThreadLocalUtil.populateMessageFromThreadLocals(message);
        for (MessageBusInterceptor messageBusInterceptor : this._serviceTrackerList) {
            if (!messageBusInterceptor.intercept((MessageBus)this, destinationName, message)) continue;
            return;
        }
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Destination " + destinationName + " is not configured"));
            }
            return;
        }
        message.setDestinationName(destinationName);
        if (message.get("companyId") == null && (companyIds = (Long[])message.get("companyIds")) != null) {
            long orignalCompanyId = CompanyThreadLocal.getCompanyId();
            try {
                for (Long id : companyIds) {
                    CompanyThreadLocal.setCompanyId((Long)id);
                    message.put("companyId", (Object)id);
                    destination.send(message.clone());
                }
            }
            finally {
                CompanyThreadLocal.setCompanyId((Long)orignalCompanyId);
            }
            return;
        }
        destination.send(message);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean force) {
        for (Destination destination : this._destinations.values()) {
            destination.close(force);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new DefaultMessageBusManagedServiceFactory(), (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)"com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration").build());
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, MessageBusInterceptor.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceRegistration.unregister();
        this.shutdown(true);
        for (Destination destination : this._destinations.values()) {
            destination.destroy();
        }
        this._destinations.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(destination.name=*)")
    protected synchronized void registerDestination(Destination destination, Map<String, Object> properties) {
        String destinationName = MapUtil.getString(properties, (String)"destination.name");
        this._addDestination(destination);
        DestinationWorkerConfiguration destinationWorkerConfiguration = this._destinationWorkerConfigurations.get(destinationName);
        this._updateDestination(destination, destinationWorkerConfiguration);
    }

    protected synchronized void unregisterDestination(Destination destination, Map<String, Object> properties) {
        this._removeDestination(destination.getName());
    }

    private void _addDestination(Destination destination) {
        Destination oldDestination = this._destinations.get(destination.getName());
        destination.open();
        this._destinations.put(destination.getName(), destination);
        if (oldDestination != null) {
            oldDestination.destroy();
        }
    }

    private Destination _removeDestination(String destinationName) {
        Destination destination = this._destinations.remove(destinationName);
        if (destination == null) {
            return null;
        }
        destination.destroy();
        return destination;
    }

    private void _updateDestination(Destination destination, DestinationWorkerConfiguration destinationWorkerConfiguration) {
        if (destination == null || destinationWorkerConfiguration == null) {
            return;
        }
        if (destination instanceof BaseAsyncDestination) {
            BaseAsyncDestination baseAsyncDestination = (BaseAsyncDestination)destination;
            baseAsyncDestination.setMaximumQueueSize(destinationWorkerConfiguration.maxQueueSize());
            baseAsyncDestination.setWorkersSize(destinationWorkerConfiguration.workerCoreSize(), destinationWorkerConfiguration.workerMaxSize());
        }
    }

    private class DefaultMessageBusManagedServiceFactory
    implements ManagedServiceFactory {
        private DefaultMessageBusManagedServiceFactory() {
        }

        public void deleted(String factoryPid) {
            String destinationName = (String)DefaultMessageBus.this._factoryPidsToDestinationNames.remove(factoryPid);
            DefaultMessageBus.this._destinationWorkerConfigurations.remove(destinationName);
        }

        public String getName() {
            return "Default Message Bus";
        }

        public void updated(String factoryPid, Dictionary<String, ?> dictionary) throws ConfigurationException {
            DestinationWorkerConfiguration destinationWorkerConfiguration = (DestinationWorkerConfiguration)ConfigurableUtil.createConfigurable(DestinationWorkerConfiguration.class, dictionary);
            DefaultMessageBus.this._factoryPidsToDestinationNames.put(factoryPid, destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._destinationWorkerConfigurations.put(destinationWorkerConfiguration.destinationName(), destinationWorkerConfiguration);
            Destination destination = (Destination)DefaultMessageBus.this._destinations.get(destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._updateDestination(destination, destinationWorkerConfiguration);
        }
    }
}

