/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerRegistry;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={MessageListenerRegistry.class})
public class MessageListenerRegistryImpl
implements MessageListenerRegistry {
    private ServiceTrackerMap<String, List<MessageListener>> _messageListenerServiceTrackerMap;

    public List<MessageListener> getMessageListeners(String destinationName) {
        List messageListeners = (List)this._messageListenerServiceTrackerMap.getService((Object)destinationName);
        if (messageListeners == null) {
            return Collections.emptyList();
        }
        return messageListeners;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._messageListenerServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, MessageListener.class, (String)"destination.name", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MessageListener, MessageListener>(){

            public MessageListener addingService(ServiceReference<MessageListener> serviceReference) {
                return new InvokerMessageListener((MessageListener)bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<MessageListener> serviceReference, MessageListener messageListener) {
            }

            public void removedService(ServiceReference<MessageListener> serviceReference, MessageListener messageListener) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._messageListenerServiceTrackerMap.close();
    }
}

