/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.messaging.internal.BaseAsyncDestination;
import com.liferay.portal.messaging.internal.MessageBusThreadLocalUtil;
import java.util.List;

public class ParallelDestination
extends BaseAsyncDestination {
    private static final Log _log = LogFactoryUtil.getLog(ParallelDestination.class);

    @Override
    protected void dispatch(List<MessageListener> messageListeners, final Message message) {
        final Thread currentThread = Thread.currentThread();
        for (final MessageListener messageListener : messageListeners) {
            MessageRunnable runnable = new MessageRunnable(message){

                public void run() {
                    try {
                        MessageBusThreadLocalUtil.populateThreadLocalsFromMessage(message, ParallelDestination.this.permissionCheckerFactory, ParallelDestination.this.userLocalService);
                        messageListener.receive(message);
                    }
                    catch (MessageListenerException messageListenerException) {
                        _log.error((Object)("Unable to process message " + message), (Throwable)messageListenerException);
                    }
                    finally {
                        if (Thread.currentThread() != currentThread) {
                            ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
                            CentralizedThreadLocal.clearShortLivedThreadLocals();
                        }
                    }
                }
            };
            this.execute((Runnable)runnable);
        }
    }
}

