/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.concurrent.atomic.AtomicLong;

public class SynchronousDestination
extends BaseDestination {
    private static final Log _log = LogFactoryUtil.getLog(SynchronousDestination.class);
    private final AtomicLong _sentMessageCounter = new AtomicLong();

    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setSentMessageCount(this._sentMessageCounter.get());
        return destinationStatistics;
    }

    public void send(Message message) {
        long companyId = message.getLong("companyId");
        if (companyId == CompanyThreadLocal.getCompanyId()) {
            this._send(message);
            return;
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId);){
            this._send(message);
        }
    }

    private void _send(Message message) {
        for (MessageListener messageListener : this.messageListenerRegistry.getMessageListeners(this.name)) {
            try {
                messageListener.receive(message);
            }
            catch (MessageListenerException messageListenerException) {
                _log.error((Object)("Unable to process message " + message), (Throwable)messageListenerException);
            }
        }
        this._sentMessageCounter.incrementAndGet();
    }
}

