/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.MessageListenerRegistry;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.messaging.internal.DestinationPrototype;
import com.liferay.portal.messaging.internal.ParallelDestination;

public class ParallelDestinationPrototype
implements DestinationPrototype {
    private final MessageListenerRegistry _messageListenerRegistry;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final PortalExecutorManager _portalExecutorManager;
    private final UserLocalService _userLocalService;

    public ParallelDestinationPrototype(MessageListenerRegistry messageListenerRegistry, PortalExecutorManager portalExecutorManager, PermissionCheckerFactory permissionCheckerFactory, UserLocalService userLocalService) {
        this._messageListenerRegistry = messageListenerRegistry;
        this._portalExecutorManager = portalExecutorManager;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._userLocalService = userLocalService;
    }

    @Override
    public Destination createDestination(DestinationConfiguration destinationConfiguration) {
        ParallelDestination parallelDestination = new ParallelDestination();
        parallelDestination.setDestinationType(destinationConfiguration.getDestinationType());
        parallelDestination.setName(destinationConfiguration.getDestinationName());
        parallelDestination.setMaximumQueueSize(destinationConfiguration.getMaximumQueueSize());
        parallelDestination.setMessageListenerRegistry(this._messageListenerRegistry);
        parallelDestination.setPermissionCheckerFactory(this._permissionCheckerFactory);
        parallelDestination.setPortalExecutorManager(this._portalExecutorManager);
        parallelDestination.setRejectedExecutionHandler(destinationConfiguration.getRejectedExecutionHandler());
        parallelDestination.setUserLocalService(this._userLocalService);
        parallelDestination.setWorkersSize(destinationConfiguration.getWorkersCoreSize(), destinationConfiguration.getWorkersMaxSize());
        return parallelDestination;
    }
}

