/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.messaging.internal.BaseAsyncDestination;
import com.liferay.portal.messaging.internal.MessageBusThreadLocalUtil;
import java.util.List;

public class SerialDestination
extends BaseAsyncDestination {
    private static final int _WORKERS_CORE_SIZE = 1;
    private static final int _WORKERS_MAX_SIZE = 1;
    private static final Log _log = LogFactoryUtil.getLog(SerialDestination.class);

    public SerialDestination() {
        this.setWorkersSize(1, 1);
    }

    @Override
    protected void dispatch(final List<MessageListener> messageListeners, final Message message) {
        final Thread currentThread = Thread.currentThread();
        MessageRunnable runnable = new MessageRunnable(message){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MessageBusThreadLocalUtil.populateThreadLocalsFromMessage(message, SerialDestination.this.permissionCheckerFactory, SerialDestination.this.userLocalService);
                    for (MessageListener messageListener : messageListeners) {
                        try {
                            messageListener.receive(message);
                        }
                        catch (MessageListenerException messageListenerException) {
                            _log.error((Object)("Unable to process message " + message), (Throwable)messageListenerException);
                        }
                    }
                }
                finally {
                    if (Thread.currentThread() != currentThread) {
                        ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
                        CentralizedThreadLocal.clearShortLivedCentralizedThreadLocals();
                    }
                }
            }
        };
        this.execute((Runnable)runnable);
    }
}

